/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PortalUtil {
    int index = 0;

    public static String formatPhoneNum(String phoneNum) {
        Pattern p2 = Pattern.compile("^((\\+{0,1}0{0,2}86){0,1})");
        Matcher m2 = p2.matcher(phoneNum);
        StringBuffer sb = new StringBuffer();
        while (m2.find()) {
            m2.appendReplacement(sb, "");
        }
        m2.appendTail(sb);
        return sb.toString().trim();
    }

    public static boolean regexCheck(String str, String rule) {
        Pattern p = Pattern.compile(rule);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static String encodeText(String text) throws UnsupportedEncodingException {
        if (StrUtil.isEmpty(text)) {
            return null;
        }
        if (PortalUtil.isBase64Regx(text)) {
            return text;
        }
        byte[] textByte = text.getBytes("UTF-8");
        Base64.Encoder encoder = Base64.getEncoder();
        String encodedText = encoder.encodeToString(textByte);
        return encodedText;
    }

    public static String decodeText(String encodeText) throws UnsupportedEncodingException {
        if (StrUtil.isEmpty(encodeText)) {
            return null;
        }
        if (!PortalUtil.isBase64Regx(encodeText)) {
            return encodeText;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        String decodeText = new String(decoder.decode(encodeText), "UTF-8");
        return decodeText;
    }

    private static boolean isBase64Regx(String str) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return Pattern.matches(base64Pattern, str);
    }

    private static boolean isBase64(String str) {
        char[] strChars;
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        if (str.length() % 4 != 0) {
            return false;
        }
        for (char c : strChars = str.toCharArray()) {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '+' || c == '/' || c == '=') continue;
            return false;
        }
        return true;
    }

    public static String getValueFromObjectProperty(String columnName, Object obj) throws Exception {
        Object propertyValue = ObjectUtil.getPropertyValue(obj, columnName);
        if (propertyValue == null) {
            return null;
        }
        return propertyValue.toString();
    }

    public static void main(String[] args) {
        String str = "\u4f5c\u4e1a\u7968\u540c\u6b65\u7ed3\u675f,\u6210\u529f1\u6761,\u5931\u8d250\u6761\u3002\u4f5c\u4e1a\u7968\u50a8\u5b58\u6210\u529f\u7684\u4f5c\u4e1a\u7968id\u6709[12833a0c-54b3-48c2-86f7-96d0f195cc7e,23433a0c-54b3-48c2-86f7-96d0f195cc7e],\u5931\u8d25\u7684\u4f5c\u4e1a\u7968id\u6709[123,456,789]\u3002\u00a0\u9519\u8bef\u539f\u56e0\u4e3a[\u4e0a\u4f20\u5931\u8d251\uff0c\u4e0a\u4f20\u5931\u8d252\uff0c\u4e0a\u4f20\u5931\u8d253]";
        PortalUtil pu = new PortalUtil();
        int capacity = 3;
        String[] res = new String[capacity];
        pu.extraResultFromStr(str, "[", "]", res, capacity);
        System.out.println("===================================");
        for (String s : res) {
            System.out.println(s);
        }
    }

    private void extraResultFromStr(String str, String startChar, String endChar, String[] res, int cap) {
        String s1;
        int endIndex = str.indexOf(endChar);
        String str2 = str.substring(endIndex + 1);
        res[this.index] = s1 = StringUtils.substringBetween((String)str, (String)startChar, (String)endChar);
        System.out.println("res" + this.index + " = " + s1);
        ++this.index;
        if (str2.contains(startChar) && str2.contains(endChar)) {
            this.extraResultFromStr(str2, startChar, endChar, res, cap);
        }
        if (this.index == cap - 1) {
            return;
        }
    }
}

