/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import cn.warpin.core.base.baseEntity.BaseEntity;
import cn.warpin.core.base.jpa.jpaComment.annotation.ColumnComment;
import cn.warpin.core.base.jpa.jpaComment.annotation.TableComment;
import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.DateUtil;
import cn.warpin.core.util.GenUtils;
import cn.warpin.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.gson.Gson;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ObjectUtil {
    private static Map<Integer, Integer> LOCKS_UPDATE = new ConcurrentHashMap<Integer, Integer>();

    public static void transMap2Bean(LinkedHashMap map, Object obj) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            Class<?> clz = obj.getClass();
            Field[] fields = clz.getDeclaredFields();
            for (PropertyDescriptor property : propertyDescriptors) {
                String key = property.getName();
                Object value = null;
                for (Field field : fields) {
                    if (!key.equals(field.getName())) continue;
                    value = map.get(key);
                    if (field.getGenericType().toString().equals("class java.lang.Long")) {
                        value = Long.valueOf(value.toString());
                    }
                    if (field.getGenericType().toString().equals("class java.lang.Integer")) {
                        value = Integer.valueOf(value.toString());
                    }
                    if (!field.getGenericType().toString().equals("class java.sql.Timestamp")) continue;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");
                    Date timeDate = new Date(Long.parseLong(value.toString()));
                    Timestamp dateTime = new Timestamp(timeDate.getTime());
                    value = dateTime;
                }
                if (!map.containsKey(key)) continue;
                Method setter = property.getWriteMethod();
                setter.invoke(obj, value);
            }
        }
        catch (Exception e) {
            System.out.println("transMap2Bean Error " + String.valueOf(e));
        }
    }

    public static MultiValueMap<String, String> convertMap(Map<String, Object> originalMap) {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (Map.Entry<String, Object> entry : originalMap.entrySet()) {
            if (entry.getValue() == null) continue;
            multiValueMap.add((Object)entry.getKey(), (Object)entry.getValue().toString());
        }
        return multiValueMap;
    }

    public static MultiValueMap<String, String> transBean2MultiValueMap(Object obj) {
        Map<String, Object> map = ObjectUtil.transBean2Map(obj);
        return ObjectUtil.convertMap(map);
    }

    public static Map<String, Object> transBean2Map(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            return (Map)obj;
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        String name = "";
        Object upperName = "";
        try {
            Field[] fields = ObjectUtil.getAllFields(obj.getClass());
            for (int i = 0; i < fields.length; ++i) {
                name = fields[i].getName();
                upperName = name.substring(0, 1).toUpperCase() + name.substring(1);
                Method getMethod = null;
                getMethod = obj.getClass().getMethod("get" + (String)upperName, new Class[0]);
                Object value = getMethod.invoke(obj, new Object[0]);
                if (null == value) continue;
                res.put(name, value);
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    public static Object constructExtendClass(Object parentObject, Class voClass) throws Exception {
        Object result = voClass.newInstance();
        String name = "";
        Object upperName = "";
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = parentObject.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        Field[] field = fieldList.toArray(new Field[fieldList.size()]);
        for (int i = 0; i < field.length; ++i) {
            name = field[i].getName();
            upperName = name.substring(0, 1).toUpperCase() + name.substring(1);
            Method getMethod = parentObject.getClass().getMethod("get" + (String)upperName, new Class[0]);
            Class<?> type = field[i].getType();
            Object value = getMethod.invoke(parentObject, new Object[0]);
            Method setMethod = result.getClass().getMethod("set" + (String)upperName, type);
            setMethod.invoke(result, value);
        }
        return result;
    }

    public static Object constructParentClass(Object childObj, Object parentObj) throws Exception {
        String name = "";
        Object upperName = "";
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = parentObj.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        Field[] field = fieldList.toArray(new Field[fieldList.size()]);
        for (int i = 0; i < field.length; ++i) {
            name = field[i].getName();
            upperName = name.substring(0, 1).toUpperCase() + name.substring(1);
            Method getMethod = childObj.getClass().getMethod("get" + (String)upperName, new Class[0]);
            Class<?> type = field[i].getType();
            Object value = getMethod.invoke(childObj, new Object[0]);
            Method setMethod = parentObj.getClass().getMethod("set" + (String)upperName, type);
            setMethod.invoke(parentObj, value);
        }
        return parentObj;
    }

    public static Object constructParallelClass(Object fromObj, Object toObj) throws Exception {
        String name = "";
        Object upperName = "";
        Field[] toField = toObj.getClass().getDeclaredFields();
        for (int i = 0; i < toField.length; ++i) {
            name = toField[i].getName();
            boolean haveField = false;
            Field[] fromField = fromObj.getClass().getDeclaredFields();
            for (int j = 0; j < fromField.length; ++j) {
                if (!name.equals(fromField[i].getName())) continue;
                haveField = true;
                break;
            }
            if (!haveField) continue;
            upperName = name.substring(0, 1).toUpperCase() + name.substring(1);
            Method getMethod = fromObj.getClass().getMethod("get" + (String)upperName, new Class[0]);
            Class<?> type = toField[i].getType();
            Object value = getMethod.invoke(fromObj, new Object[0]);
            Method setMethod = toObj.getClass().getMethod("set" + (String)upperName, type);
            setMethod.invoke(toObj, value);
        }
        return toObj;
    }

    public static Map<String, Object> getVOClassMap(Object entityCondition) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String packagePrefix = "cn.warpin.business";
        String nameWithPkg = "";
        try {
            Field[] fields = entityCondition.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                nameWithPkg = fields[i].getName();
                if (!nameWithPkg.startsWith("pkg_")) continue;
                HashMap<String, Object> resValue = new HashMap<String, Object>();
                Method getMethod = entityCondition.getClass().getMethod("get" + GenUtils.upperCaseFirstName(nameWithPkg), new Class[0]);
                Object value = getMethod.invoke(entityCondition, new Object[0]);
                if (null == value) continue;
                String className = GenUtils.transformTableName(value.toString(), true);
                List matchingClasses = Arrays.stream(Package.getPackages()).map(Package::getName).filter(packageName -> packageName.startsWith(packagePrefix)).map(packageName -> {
                    try {
                        return Class.forName(packageName + "." + className + "VO");
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }).filter(clazz -> clazz != null && BaseEntity.class.isAssignableFrom((Class<?>)clazz)).collect(Collectors.toList());
                if (ArrayUtil.isEmpty(matchingClasses)) continue;
                Class clz = (Class)matchingClasses.get(0);
                String propertyName = nameWithPkg.substring("pkg_".length());
                String keyName = "";
                keyName = propertyName.endsWith("father") ? StrUtil.transformName(propertyName.substring(0, propertyName.lastIndexOf("_")), false) : StrUtil.transformName(propertyName, false);
                resValue.put(keyName, clz);
                resValue.put("pkg_val", value);
                result.put(nameWithPkg, resValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
    }

    public static void copyMapPropertiesToClass(Map<String, Object> origin, Object target) {
        if (origin == null) {
            return;
        }
        String nameWithPkg = "";
        try {
            Field[] fields;
            for (Field field : fields = ObjectUtil.getAllFields(target.getClass())) {
                Object value;
                int modifiers = field.getModifiers();
                if (Modifier.isFinal(modifiers) || (value = origin.get(nameWithPkg = field.getName())) == null) continue;
                Class<?> type = field.getType();
                value = ObjectUtil.parseObjectValue(type, value);
                Method setMethod = target.getClass().getMethod("set" + GenUtils.upperCaseFirstName(nameWithPkg), type);
                setMethod.invoke(target, value);
            }
        }
        catch (Exception e) {
            throw new ResultException(ResCode.SERVER_COMMON_ERROR);
        }
    }

    public static Field[] getAllFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        return fieldList.toArray(fields);
    }

    public static Object getPropertyValue(Object object, String key) {
        String name = "";
        Object upperName = "";
        Object value = null;
        Field[] fields = ObjectUtil.getAllFields(object.getClass());
        try {
            for (int i = 0; i < fields.length; ++i) {
                name = fields[i].getName();
                if (!name.equals(key)) continue;
                upperName = name.substring(0, 1).toUpperCase() + name.substring(1);
                Method getMethod = object.getClass().getMethod("get" + (String)upperName, new Class[0]);
                value = getMethod.invoke(object, new Object[0]);
                break;
            }
        }
        catch (Exception e) {
            throw new ResultException(ResCode.SERVER_COMMON_ERROR);
        }
        return value;
    }

    public static List<String> getPropertyValues(Object object, String ... keys) throws Exception {
        ArrayList<String> resultList = new ArrayList<String>();
        String name = "";
        Object upperName = "";
        Object value = null;
        Field[] field = object.getClass().getDeclaredFields();
        block0: for (int i = 0; i < field.length; ++i) {
            name = field[i].getName();
            for (String key : keys) {
                if (!name.equals(key)) continue;
                upperName = name.substring(0, 1).toUpperCase() + name.substring(1);
                Method getMethod = object.getClass().getMethod("get" + (String)upperName, new Class[0]);
                value = getMethod.invoke(object, new Object[0]);
                if (value == null || !StrUtil.isNotEmpty(value.toString())) continue block0;
                resultList.add(value.toString());
                continue block0;
            }
        }
        return resultList;
    }

    public static List<Map<String, Object>> toListMap(List<?> list) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Object o : list) {
            Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString(o), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            result.add(map);
        }
        return result;
    }

    public static String tojson(Object obj) {
        if (null == obj) {
            return null;
        }
        Gson gson = new Gson();
        String jsonStr = gson.toJson(obj);
        return jsonStr;
    }

    public static Object toObject(String jsonStr, Class clazz) {
        if (StrUtil.isEmpty(jsonStr)) {
            return null;
        }
        Gson gson = new Gson();
        Object resObj = gson.fromJson(jsonStr, clazz);
        return resObj;
    }

    public static List typedList(List untypedList, Class itemClass, Class listClass) {
        List list = null;
        try {
            list = (List)listClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Object item : untypedList) {
            list.add(itemClass.cast(item));
        }
        return list;
    }

    public static Object getLockByPrimaryKey(Integer id) {
        LOCKS_UPDATE.putIfAbsent(id, id);
        return LOCKS_UPDATE.get(id);
    }

    public static void unLockByPrimaryKey(Integer id) {
        LOCKS_UPDATE.remove(id);
    }

    private static Object parseObjectValue(Class<?> type, Object value) {
        if (value == null) {
            return null;
        }
        if (type == Timestamp.class) {
            value = DateUtil.stringToTimestamp(value.toString());
        }
        if (type == Date.class) {
            value = DateUtil.stringToSqlDate(value.toString(), "yyyy-MM-dd");
        }
        if (type == Integer.class) {
            value = Integer.parseInt(value.toString());
        }
        if (type == Long.class) {
            value = Long.parseLong(value.toString());
        }
        if (type == Double.class) {
            value = Double.parseDouble(value.toString());
        }
        if (type == BigDecimal.class) {
            value = new BigDecimal(value.toString());
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String classFinder(String targetClass) {
        try {
            String[] classPathEntries;
            Enumeration<URL> roots = Thread.currentThread().getContextClassLoader().getResources("");
            while (roots.hasMoreElements()) {
                URL url = roots.nextElement();
                if ("file".equals(url.getProtocol())) {
                    String fullClassName;
                    File file = new File(url.toURI());
                    if (!file.isDirectory() || (fullClassName = ObjectUtil.findClassesInDirectory(file, targetClass, "")) == null) continue;
                    return fullClassName;
                }
                if (!"jar".equals(url.getProtocol())) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                try {
                    String fullClassName = ObjectUtil.findClassesInJar(jarFile, targetClass);
                    if (fullClassName == null) continue;
                    String string = fullClassName;
                    return string;
                }
                finally {
                    if (jarFile == null) continue;
                    jarFile.close();
                }
            }
            String classPath = System.getProperty("java.class.path");
            String[] stringArray = classPathEntries = classPath.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                Path path = Paths.get(entry, new String[0]);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    String fullClassName = ObjectUtil.findClassesInDirectory(path.toFile(), targetClass, "");
                    if (fullClassName != null) {
                        return fullClassName;
                    }
                } else if (entry.endsWith(".jar")) {
                    try (JarFile jarFile = new JarFile(new File(entry));){
                        String fullClassName = ObjectUtil.findClassesInJar(jarFile, targetClass);
                        if (fullClassName != null) {
                            String string = fullClassName;
                            return string;
                        }
                    }
                }
                ++n2;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed during class search", e);
        }
    }

    private static String findClassesInDirectory(File directory, String targetClass, String packageName) {
        File[] files = directory.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            String className;
            if (file.isDirectory()) {
                String result = ObjectUtil.findClassesInDirectory(file, targetClass, packageName + file.getName() + ".");
                if (result == null) continue;
                return result;
            }
            if (!file.getName().endsWith(".class") || !(className = packageName + file.getName().replaceAll("\\.class$", "")).endsWith("." + targetClass)) continue;
            return className;
        }
        return null;
    }

    private static String findClassesInJar(JarFile jarFile, String targetClass) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String className;
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class") || !(className = entry.getName().replace("/", ".").replaceAll("\\.class$", "")).endsWith("." + targetClass)) continue;
            return className;
        }
        return null;
    }

    public static String getClassTableComment(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (clazz.isAnnotationPresent(TableComment.class)) {
                TableComment tableComment = clazz.getAnnotation(TableComment.class);
                return tableComment.value();
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException();
        }
        return null;
    }

    public static String getFieldComment(String className, String fieldName) {
        try {
            Class<?> clazz = Class.forName(className);
            Field field = ObjectUtil.getDeclaredFieldIncludingSuperclasses(fieldName, clazz);
            if (field != null && field.isAnnotationPresent(ColumnComment.class)) {
                ColumnComment columnComment = field.getAnnotation(ColumnComment.class);
                return columnComment.value();
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static Field getDeclaredFieldIncludingSuperclasses(String fieldName, Class<?> clazz) {
        Field field = null;
        while (clazz != null) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return field;
    }

    public static void setPropertyValue(Object object, String key, Object value) throws Exception {
        Field field = ObjectUtil.getField(object.getClass(), key);
        Class<?> fieldType = field.getType();
        Object convertedValue = value;
        if (fieldType != String.class) {
            if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                convertedValue = Integer.valueOf(value.toString());
            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                convertedValue = Long.valueOf(value.toString());
            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                convertedValue = Double.valueOf(value.toString());
            } else if (fieldType == Float.class || fieldType == Float.TYPE) {
                convertedValue = Float.valueOf(value.toString());
            } else if (fieldType == BigDecimal.class) {
                convertedValue = new BigDecimal(value.toString());
            } else if (fieldType == Date.class) {
                convertedValue = DateUtil.stringToDate(value.toString(), "yyyy-MM-dd HH:mm:ss");
            } else if (fieldType == Timestamp.class) {
                java.util.Date d = DateUtil.stringToDate(value.toString(), "yyyy-MM-dd HH:mm:ss");
                convertedValue = new Timestamp(d.getTime());
            }
        }
        String upperName = StrUtil.upperCaseFirstName(key);
        Method setMethod = object.getClass().getMethod("set" + upperName, fieldType);
        setMethod.invoke(object, convertedValue);
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            if (clazz.getSuperclass() != null) {
                return ObjectUtil.getField(clazz.getSuperclass(), fieldName);
            }
            return null;
        }
    }
}

