/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class Numbers {
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    static final Map<Character, Integer> digitMap = new HashMap<Character, Integer>();
    public static final int MAX_RADIX;
    public static final int MIN_RADIX = 2;

    public static String toString(long i, int radix) {
        boolean negative;
        if (radix < 2 || radix > MAX_RADIX) {
            radix = 10;
        }
        if (radix == 10) {
            return Long.toString(i);
        }
        int size = 65;
        int charPos = 64;
        char[] buf = new char[65];
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= (long)(-radix)) {
            buf[charPos--] = digits[(int)(-(i % (long)radix))];
            i /= (long)radix;
        }
        buf[charPos] = digits[(int)(-i)];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 65 - charPos);
    }

    static NumberFormatException forInputString(String s) {
        return new NumberFormatException("For input string: \"" + s + "\"");
    }

    public static long toNumber(String s, int radix) {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Numbers.MIN_RADIX");
        }
        if (radix > MAX_RADIX) {
            throw new NumberFormatException("radix " + radix + " greater than Numbers.MAX_RADIX");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int len = s.length();
        long limit = -9223372036854775807L;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw Numbers.forInputString(s);
                }
                if (len == 1) {
                    throw Numbers.forInputString(s);
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            while (i < len) {
                Integer digit;
                if ((digit = digitMap.get(Character.valueOf(s.charAt(i++)))) == null) {
                    throw Numbers.forInputString(s);
                }
                if (digit < 0) {
                    throw Numbers.forInputString(s);
                }
                if (result < multmin) {
                    throw Numbers.forInputString(s);
                }
                if ((result *= (long)radix) < limit + (long)digit.intValue()) {
                    throw Numbers.forInputString(s);
                }
                result -= (long)digit.intValue();
            }
        } else {
            throw Numbers.forInputString(s);
        }
        return negative ? result : -result;
    }

    public static String generateSMSCode() {
        Integer num = new Random().nextInt(899999) + 100000;
        return num.toString();
    }

    public static double formatScore(double value) {
        double result = 0.0;
        String var = "" + value;
        int index = var.indexOf(".") + 1;
        int firstDigit = Integer.parseInt(var.substring(0, 1));
        String lastVar = var.substring(index, index + 1);
        int lastDigit = Integer.parseInt(lastVar);
        result = firstDigit >= 5 ? 5.0 : (lastDigit > 5 ? (double)firstDigit + 1.0 : (lastDigit == 0 ? (double)firstDigit + 0.0 : (double)firstDigit + 0.5));
        return result;
    }

    public static String generateEmpCode() {
        int min = 200100;
        int max = 999999;
        Random rand = new Random();
        int num = rand.nextInt(max - min - 1) + min + 1;
        return String.valueOf(num);
    }

    static {
        for (int i = 0; i < digits.length; ++i) {
            digitMap.put(Character.valueOf(digits[i]), i);
        }
        MAX_RADIX = digits.length;
    }

    public static class HandleNumber {
        public static BigDecimal doubleToBigDecimal(Double d) {
            if (null == d) {
                return null;
            }
            BigDecimal bigDecimal = new BigDecimal(d.toString());
            return bigDecimal;
        }

        public static Long bigDecimalParseToLong(Object object) {
            if (null == object) {
                return null;
            }
            BigDecimal bigDecimal = new BigDecimal((BigInteger)object);
            Long longNum = bigDecimal.longValue();
            return longNum;
        }

        public static Integer bigDecimalParseToInteger(Object object) {
            if (null == object) {
                return null;
            }
            BigDecimal bigDecimal = new BigDecimal((Integer)object);
            Integer integerNum = bigDecimal.intValue();
            return integerNum;
        }

        public static Double bigDecimalParseToDouble(Object object) {
            if (null == object) {
                return 0.0;
            }
            BigDecimal bigDecimal = new BigDecimal((Double)object);
            Double integerNum = bigDecimal.doubleValue();
            return integerNum;
        }

        public static void main(String[] args) {
            double a = 1.2677149613739474E7;
            Double b = HandleNumber.bigDecimalParseToDouble(a);
            System.out.println(b);
        }

        public static Double DoubleFix(Double d, Integer num) {
            if (d == null) {
                return null;
            }
            if (num == null) {
                return d;
            }
            BigDecimal b = new BigDecimal(d);
            d = b.setScale((int)num, 4).doubleValue();
            return d;
        }
    }
}

