/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private String authorizationHeader;

    public String postJson(RestTemplate restTemplate, String url, Object content) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (StrUtil.isNotEmpty(this.authorizationHeader)) {
            headers.set("Authorization", this.authorizationHeader);
        }
        String serviceData = JSON.toJSONString((Object)content);
        HttpEntity entity = new HttpEntity((Object)serviceData, (MultiValueMap)headers);
        String response = null;
        try {
            response = (String)restTemplate.postForObject(url, (Object)entity, String.class, new Object[0]);
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            throw new RuntimeException(errMsg);
        }
        System.out.println("==========\u8bf7\u6c42\u5730\u5740==========> : \n" + url);
        System.out.println("==========\u8bf7\u6c42\u7ed3\u679c==========> : \n" + response);
        return response;
    }

    public String postJson(RestTemplate restTemplate, String url, Object content, String username, String password) {
        String credentials = username + ":" + password;
        String encodedCredentials = Base64.getEncoder().encodeToString(credentials.getBytes());
        this.authorizationHeader = "Basic " + encodedCredentials;
        return this.postJson(restTemplate, url, content);
    }

    public String postForm(RestTemplate restTemplate, String url, Object content) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        if (StrUtil.isNotEmpty(this.authorizationHeader)) {
            headers.set("Authorization", this.authorizationHeader);
        }
        MultiValueMap<String, String> map = ObjectUtil.transBean2MultiValueMap(content);
        HttpEntity entity = new HttpEntity(map, (MultiValueMap)headers);
        String response = null;
        try {
            response = (String)restTemplate.postForObject(url, (Object)entity, String.class, new Object[0]);
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            throw new RuntimeException(errMsg);
        }
        System.out.println("==========\u8bf7\u6c42\u5730\u5740==========> : \n" + url);
        System.out.println("==========\u8bf7\u6c42\u7ed3\u679c==========> : \n" + response);
        return response;
    }

    public String postForm(RestTemplate restTemplate, String url, Object content, String username, String password) {
        String credentials = username + ":" + password;
        String encodedCredentials = Base64.getEncoder().encodeToString(credentials.getBytes());
        this.authorizationHeader = "Basic " + encodedCredentials;
        return this.postForm(restTemplate, url, content);
    }

    public String get(RestTemplate restTemplate, String url, Object content) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
        if (content != null) {
            MultiValueMap<String, String> map = ObjectUtil.transBean2MultiValueMap(content);
            for (Map.Entry entry : map.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    if (!StrUtil.isNotEmpty(value)) continue;
                    builder.queryParam((String)entry.getKey(), new Object[]{value});
                }
            }
        }
        String finalUrl = builder.toUriString();
        String response = null;
        try {
            response = (String)restTemplate.getForObject(finalUrl, String.class, new Object[0]);
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            throw new RuntimeException(errMsg);
        }
        System.out.println("==========\u8bf7\u6c42\u5730\u5740==========> : \n" + finalUrl);
        System.out.println("==========\u8bf7\u6c42\u7ed3\u679c==========> : \n" + response);
        return response;
    }

    public static String executeGet(String url, String token) {
        String result = null;
        SSLContext sslContext = SSLContexts.createSystemDefault();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslSocketFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry, PoolConcurrencyPolicy.STRICT, PoolReusePolicy.LIFO, (TimeValue)Timeout.ofSeconds((long)30L), null);
        cm.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofSeconds((long)30L)).build());
        try (CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)30L)).setConnectTimeout(Timeout.ofSeconds((long)30L)).setResponseTimeout(Timeout.ofSeconds((long)30L)).build()).build();){
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", (Object)token);
            result = (String)httpClient.execute((ClassicHttpRequest)httpGet, response -> EntityUtils.toString((org.apache.hc.core5.http.HttpEntity)response.getEntity(), (String)"UTF-8"));
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return result;
    }

    public static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.isEmpty() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.contains(",")) {
            ip = ip.split(",")[0].trim();
        }
        return ip;
    }
}

