/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;

public class FileConvertUtil {
    public static void convertPPTToImages(String pptPath, String outputDir) throws IOException {
        try (FileInputStream fis = new FileInputStream(pptPath);
             XMLSlideShow ppt = new XMLSlideShow((InputStream)fis);){
            File outputDirectory = new File(outputDir);
            if (!outputDirectory.exists()) {
                outputDirectory.mkdirs();
            }
            for (int i = 0; i < ppt.getSlides().size(); ++i) {
                XSLFSlide slide = (XSLFSlide)ppt.getSlides().get(i);
                Dimension pgsize = ppt.getPageSize();
                BufferedImage img = new BufferedImage(pgsize.width, pgsize.height, 1);
                Graphics2D graphics = img.createGraphics();
                graphics.setPaint(Color.WHITE);
                graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, pgsize.width, pgsize.height));
                try {
                    slide.draw(graphics);
                }
                catch (NullPointerException e) {
                    System.err.println("Error drawing slide: " + e.getMessage());
                    e.printStackTrace();
                }
                File imgFile = new File(outputDirectory, "slide_" + (i + 1) + ".png");
                ImageIO.write((RenderedImage)img, "png", imgFile);
            }
        }
    }

    public static String convertPDFToHTML(String pdfPath, String outputDir) throws IOException {
        StringBuilder html = new StringBuilder();
        File file = new File(pdfPath);
        File outputDirectory = new File(outputDir);
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        try (PDDocument document = PDDocument.load((File)file);){
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            html.append("<html><body>");
            for (int page = 0; page < document.getNumberOfPages(); ++page) {
                BufferedImage bim = pdfRenderer.renderImageWithDPI(page, 150.0f);
                File outputFile = new File(outputDirectory, "page_" + page + ".jpg");
                try (ImageOutputStream ios = ImageIO.createImageOutputStream(outputFile);){
                    ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
                    writer.setOutput(ios);
                    ImageWriteParam param = writer.getDefaultWriteParam();
                    param.setCompressionMode(2);
                    param.setCompressionQuality(0.7f);
                    writer.write(null, new IIOImage(bim, null, null), param);
                    writer.dispose();
                }
                String relativePath = "./temp/page_" + page + ".jpg";
                html.append("<img src='").append(relativePath).append("' /><br/>");
            }
            html.append("</body></html>");
        }
        return html.toString();
    }

    public static List<String> convertPDFToImages(String pdfPath, String outputDir) {
        ArrayList<String> imagePaths = new ArrayList<String>();
        File file = new File(pdfPath);
        File outputDirectory = new File(outputDir);
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        try (PDDocument document = PDDocument.load((File)file);){
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            for (int page = 0; page < document.getNumberOfPages(); ++page) {
                BufferedImage bim = pdfRenderer.renderImageWithDPI(page, 75.0f);
                File outputFile = new File(outputDirectory, "page_" + page + ".jpg");
                try (ImageOutputStream ios = ImageIO.createImageOutputStream(outputFile);){
                    ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
                    writer.setOutput(ios);
                    ImageWriteParam param = writer.getDefaultWriteParam();
                    param.setCompressionMode(2);
                    param.setCompressionQuality(0.7f);
                    writer.write(null, new IIOImage(bim, null, null), param);
                    writer.dispose();
                }
                imagePaths.add(outputFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return imagePaths;
    }
}

