/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import cn.warpin.core.util.StrUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    public static final String FORMATTYPE_1 = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMATTYPE_2 = "MM\u6708dd\u65e5";
    public static final String FORMATTYPE_3 = "yyyyMMdd";
    public static final String FORMATTYPE_4 = "yyyy-MM-dd HH:mm";
    public static final String FORMATTYPE_5 = "yyyy-MM-dd";
    public static final String FORMATTYPE_6 = "HH:mm:ss";
    public static final String FORMATTYPE_7 = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FORMATTYPE_8 = "yyyyMMddHHmmss";
    public static final String FORMATTYPE_9 = "yyyyMMddHHmmss.SSS";
    public static final String FORMATTYPE_10 = "yyyyMMddHHmmssSSS";
    public static final String FORMATTYPE_11 = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    public static Date sqlDateToUtilDate(Date sqlDate) {
        if (null == sqlDate) {
            return null;
        }
        Date date = new Date(sqlDate.getTime());
        return date;
    }

    public static java.sql.Date utilDateToSqlDate(Date utilDate) {
        if (null == utilDate) {
            return null;
        }
        java.sql.Date sqlDate = new java.sql.Date(utilDate.getTime());
        return sqlDate;
    }

    public static String dateToString(Date date, String formatType) {
        return new SimpleDateFormat(formatType).format(date);
    }

    public static String sql_dateToString(java.sql.Date date, String formatType) {
        return new SimpleDateFormat(formatType).format(date);
    }

    public static String longToString(long currentTime, String formatType) {
        Date date = null;
        String strTime = null;
        date = DateUtil.longToDate(currentTime, formatType);
        strTime = DateUtil.dateToString(date, formatType);
        return strTime;
    }

    public static Date stringToDate(String strTime, String formatType) {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        Date date = null;
        try {
            date = formatter.parse(strTime);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public static java.sql.Date stringToSqlDate(String strTime, String formatType) {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        java.sql.Date date = null;
        try {
            date = new java.sql.Date(formatter.parse(strTime).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public static Timestamp stringToTimestamp(String strTime) {
        return Timestamp.valueOf(strTime);
    }

    public static String timestampToString(Timestamp timestamp, String formatType) {
        return new SimpleDateFormat(formatType).format(timestamp.getTime());
    }

    public static Date longToDate(long currentTime, String formatType) {
        Date dateOld = new Date(currentTime);
        String sDateTime = DateUtil.dateToString(dateOld, formatType);
        return DateUtil.stringToDate(sDateTime, formatType);
    }

    public static long stringToLong(String strTime, String formatType) {
        Date date = DateUtil.stringToDate(strTime, formatType);
        if (date == null) {
            return 0L;
        }
        long currentTime = DateUtil.dateToLong(date);
        return currentTime;
    }

    public static long dateToLong(Date date) {
        return date.getTime();
    }

    public static Long getDateZero(int hours) {
        if (hours % 24 != 0) {
            return null;
        }
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        long timeMillis = zero + (long)(hours * 60 * 60 * 1000);
        return timeMillis;
    }

    public static int getWeekNum(Date startDate, Date checkDate) {
        int num = 0;
        int firstDayOfWeek = DateUtil.dayOfWeek(startDate);
        int weekMills = 604800000;
        int leftDay = 7 - firstDayOfWeek;
        long leftMillis = leftDay * 24 * 3600 * 1000;
        long checkMillis = checkDate.getTime();
        long after1stWeekMills = checkMillis - leftMillis;
        long minusMills = after1stWeekMills - startDate.getTime();
        while (true) {
            if ((minusMills -= (long)weekMills) <= 0L) {
                ++num;
                break;
            }
            ++num;
        }
        return ++num;
    }

    public static int dayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return w;
    }

    public static boolean compareDate(Date targetDate, Date baseDate) {
        long between = targetDate.getTime() - baseDate.getTime();
        return between > 86400000L;
    }

    public static String timePlusFmt(Date date) {
        String time = DateUtil.dateToString(date, FORMATTYPE_7);
        Date date1 = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATTYPE_5);
        String dateStr = sdf.format(date1);
        String fullDateStr = dateStr + " " + time;
        Timestamp timestamp = DateUtil.stringToTimestamp(fullDateStr);
        String result = DateUtil.longToString(timestamp.getTime(), FORMATTYPE_7);
        return result;
    }

    public static String timePlusFmt(String time) {
        String result = null;
        Date date1 = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATTYPE_5);
        String dateStr = sdf.format(date1);
        result = dateStr + " " + time;
        return result;
    }

    public static boolean isYeaterday(Date oldTime, Date newTime) throws Exception {
        String todayStr;
        SimpleDateFormat format;
        Date today;
        if (null == oldTime) {
            return false;
        }
        if (newTime == null) {
            newTime = new Date();
        }
        return (today = (format = new SimpleDateFormat(FORMATTYPE_5)).parse(todayStr = format.format(newTime))).getTime() - oldTime.getTime() > 0L && today.getTime() - oldTime.getTime() <= 86400000L;
    }

    public static Integer calTimeRageToDays(Long beginTime, Long endTime) {
        Integer days = 0;
        if (endTime < beginTime) {
            return -1;
        }
        Long time = endTime - beginTime;
        Long daysTime = time / 86400000L;
        days = daysTime.intValue();
        return days;
    }

    public static String getCalendarNum(String dateStr, Integer calendarType) {
        String result = null;
        Date date = null;
        if (StrUtil.isEmpty(dateStr)) {
            date = new Date();
        } else {
            try {
                date = new SimpleDateFormat(FORMATTYPE_5).parse(dateStr);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        Calendar calendar = Calendar.getInstance(Locale.CHINESE);
        calendar.setTime(date);
        if (calendarType == null) {
            result = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5);
            return result;
        }
        switch (calendarType) {
            case 1: {
                result = "" + calendar.get(1);
                break;
            }
            case 2: {
                result = "" + (calendar.get(2) + 1);
                break;
            }
            case 5: {
                result = "" + calendar.get(5);
                break;
            }
            case 7: {
                result = "" + calendar.get(7);
                break;
            }
            case 6: {
                result = "" + calendar.get(6);
            }
        }
        return result;
    }

    public static Timestamp getStartOfWeek() {
        LocalDate today = LocalDate.now(ZoneId.systemDefault());
        LocalDate startOfWeek = today.with(DayOfWeek.MONDAY);
        return Timestamp.valueOf(startOfWeek.atStartOfDay());
    }

    public static String getOffsetTime(Long time) {
        Instant instant = Instant.ofEpochMilli(System.currentTimeMillis());
        ZoneId zoneId = ZoneId.of("Asia/Shanghai");
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMATTYPE_11);
        return zonedDateTime.format(formatter);
    }

    public static Timestamp getDayStartTime(String dateStr) {
        Date date = DateUtil.stringToDate(dateStr, FORMATTYPE_5);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date startDate = calendar.getTime();
        return new Timestamp(startDate.getTime());
    }

    public static Timestamp getDayEndTime(String dateStr) {
        Date date = DateUtil.stringToDate(dateStr, FORMATTYPE_5);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        Date endDate = calendar.getTime();
        return new Timestamp(endDate.getTime());
    }

    public static void main(String[] args) {
        String s = "2024-11-22";
        System.out.println(DateUtil.getDayEndTime(s));
    }
}

