/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckUtil {
    public static boolean isValidPhoneNumber(String phoneNumber) {
        String regex = "^(13[0-9]|14[579]|15[0-3,5-9]|16[6]|17[0135678]|18[0-9]|19[89])\\d{8}$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(phoneNumber);
        return matcher.matches();
    }

    public static boolean isValidIDCard(String idCardNumber) {
        String regex = "^(\\d{15}$|^\\d{18}$|^\\d{17}(\\d|X|x))$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(idCardNumber);
        return matcher.matches();
    }

    public static boolean isValidEmail(String email) {
        String regex = "^[A-Za-z0-9+_.-]+@(.+)$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }

    public static boolean checkEmpCode(String code, String ... cap) {
        String start = "6";
        String end = "10";
        if (cap != null && cap.length > 0) {
            block4: for (int i = 0; i < cap.length; ++i) {
                switch (i) {
                    case 0: {
                        start = cap[0];
                        continue block4;
                    }
                    case 1: {
                        end = cap[1];
                    }
                }
            }
        }
        String regex = "^\\d{" + start + "," + end + "}$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(code);
        return matcher.matches();
    }
}

