/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.util;

import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class ArrayUtil {
    public static boolean isEmpty(List list) {
        return list == null || list.size() == 0;
    }

    public static boolean isNotEmpty(List list) {
        return list != null && list.size() > 0;
    }

    public static List removeDuplicateWithOrder(List list) {
        HashSet set = new HashSet();
        ArrayList newList = new ArrayList();
        for (Object element : list) {
            if (!set.add(element)) continue;
            newList.add(element);
        }
        return newList;
    }

    public static Boolean checkNumberInArray(Integer number, List<Integer> numList) {
        if (ArrayUtil.isEmpty(numList)) {
            return false;
        }
        for (Integer num : numList) {
            if (!number.equals(num)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> removeDuplicatesByKey(List<T> list, Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        Predicate<Object> distinctByKey = t -> seen.add(keyExtractor.apply(t));
        return list.stream().filter(distinctByKey).toList();
    }

    public static <T> void sortList(List<T> list, String orderByFieldName, String orderByOption) {
        if (list == null || orderByFieldName == null || orderByOption == null) {
            return;
        }
        String methodName = "get" + orderByFieldName.substring(0, 1).toUpperCase() + orderByFieldName.substring(1);
        list.sort((o1, o2) -> {
            try {
                Method method = o1.getClass().getMethod(methodName, new Class[0]);
                Comparable value1 = (Comparable)method.invoke(o1, new Object[0]);
                Comparable value2 = (Comparable)method.invoke(o2, new Object[0]);
                return "ASC".equals(orderByOption) ? value1.compareTo(value2) : value2.compareTo(value1);
            }
            catch (Exception e) {
                throw new ResultException(ResCode.SERVER_COMMON_ERROR);
            }
        });
    }
}

