/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.result;

import cn.warpin.core.result.ResCode;
import cn.warpin.core.util.StrUtil;
import java.util.List;
import org.springframework.data.domain.Page;

public class Result {
    private Object root;
    private String msg;
    private Integer code;
    private long count;
    private int totalPage;
    private List<Integer> primaries;

    public static Result querySuccess(Object root) {
        return new Result(root, ResCode.SUCCESS);
    }

    public static Result querySuccess(Object root, long totalCount, int totalPage) {
        Result rs = new Result(root, ResCode.SUCCESS);
        rs.count = totalCount;
        rs.totalPage = totalPage;
        return rs;
    }

    public static Result querySuccess(Object root, List<Integer> primaries) {
        Result rs = new Result(root, ResCode.SUCCESS);
        rs.primaries = primaries;
        return rs;
    }

    public static Result querySuccess(Object root, long totalCount, int totalPage, List<Integer> primaries) {
        Result rs = new Result(root, ResCode.SUCCESS);
        rs.count = totalCount;
        rs.totalPage = totalPage;
        rs.primaries = primaries;
        return rs;
    }

    public static Result success() {
        return new Result(ResCode.SUCCESS);
    }

    public static Result success(ResCode rc, String msg) {
        return new Result(rc, msg);
    }

    public static Result success(Object root) {
        return new Result(root, ResCode.SUCCESS);
    }

    public static Result success(Object root, ResCode rc) {
        return new Result(root, rc);
    }

    public static Result success(Object root, ResCode rc, String msg) {
        return new Result(root, rc, msg);
    }

    public static Result success(Object root, Long totalCount) {
        return new Result(root, ResCode.SUCCESS, totalCount);
    }

    public static Result success(Page<?> page) {
        return new Result(page, ResCode.SUCCESS);
    }

    public static Result fail() {
        return new Result(ResCode.SERVER_COMMON_ERROR);
    }

    public static Result fail(ResCode rc) {
        return new Result(rc);
    }

    public static Result fail(ResCode rc, String msg) {
        return new Result(rc, msg);
    }

    public static Result fail(Object root, ResCode rc) {
        return new Result(root, rc);
    }

    public static Result fail(Object root, ResCode rc, String msg) {
        return new Result(root, rc, msg);
    }

    public static Result fail(Integer resCode, String msg) {
        return new Result(resCode, msg);
    }

    public Result(ResCode rc) {
        this.code = rc.getKey();
        this.msg = rc.getValue();
    }

    public Result(ResCode rc, String msg) {
        this.code = rc.getKey();
        this.msg = msg;
    }

    public static Result exception(Exception e) {
        e.printStackTrace();
        return new Result(e, ResCode.SERVER_COMMON_ERROR);
    }

    public Result(Integer resCode, String msg) {
        this.code = resCode;
        this.msg = msg;
    }

    public Result(Object root, ResCode rc) {
        this.root = root;
        this.code = rc.getKey();
        this.msg = rc.getValue();
    }

    public Result(Object root, ResCode rc, String msg) {
        this.root = root;
        this.code = rc.getKey();
        this.msg = StrUtil.isEmpty(msg) ? rc.getValue() : msg;
    }

    public Result(Object root, ResCode rc, Long totalCount) {
        this.root = root;
        this.code = rc.getKey();
        this.msg = rc.getValue();
        this.count = totalCount;
    }

    public Object getRoot() {
        return this.root;
    }

    public String getMsg() {
        return this.msg;
    }

    public Integer getCode() {
        return this.code;
    }

    public long getCount() {
        return this.count;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public List<Integer> getPrimaries() {
        return this.primaries;
    }

    public void setRoot(Object root) {
        this.root = root;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public void setPrimaries(List<Integer> primaries) {
        this.primaries = primaries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        Object this$root = this.getRoot();
        Object other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        List<Integer> this$primaries = this.getPrimaries();
        List<Integer> other$primaries = other.getPrimaries();
        return !(this$primaries == null ? other$primaries != null : !((Object)this$primaries).equals(other$primaries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        result = result * 59 + this.getTotalPage();
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        Object $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        List<Integer> $primaries = this.getPrimaries();
        result = result * 59 + ($primaries == null ? 43 : ((Object)$primaries).hashCode());
        return result;
    }

    public String toString() {
        return "Result(root=" + String.valueOf(this.getRoot()) + ", msg=" + this.getMsg() + ", code=" + this.getCode() + ", count=" + this.getCount() + ", totalPage=" + this.getTotalPage() + ", primaries=" + String.valueOf(this.getPrimaries()) + ")";
    }
}

