/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.exception;

import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;

public class ResultException
extends RuntimeException {
    private Integer code;
    private String msg;

    public ResultException(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public ResultException(ResCode resCode) {
        this.code = resCode.getKey();
        this.msg = resCode.getValue();
    }

    public ResultException(ResCode resCode, String msg) {
        this.code = resCode.getKey();
        this.msg = msg;
    }

    public ResultException(String key) {
        Result result = Result.success(key);
        this.code = result.getCode();
        this.msg = result.getMsg();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultException)) {
            return false;
        }
        ResultException other = (ResultException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Override
    public String toString() {
        return "ResultException(code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }
}

