/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.database.redis;

import cn.warpin.core.constant.Constants;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;

public class RedisClientSingleton {
    private static RedisClient redisClient;

    private RedisClientSingleton() {
    }

    public static synchronized RedisClient getRedisClient() {
        if (redisClient == null) {
            char[] pwdCharArray = Constants.REDIS_PWD.toCharArray();
            RedisURI redisUri = RedisURI.builder().withHost(Constants.REDIS_IP).withPort(Constants.REDIS_PORT.intValue()).withDatabase(Constants.REDIS_DB_INDEX.intValue()).withPassword(pwdCharArray).build();
            redisClient = RedisClient.create((RedisURI)redisUri);
        }
        return redisClient;
    }

    public static synchronized RedisClient getRedisClient(String ip, int port, int index, String password) {
        if (redisClient == null) {
            char[] pwdCharArray = password.toCharArray();
            RedisURI redisUri = RedisURI.builder().withHost(ip).withPort(port).withDatabase(index).withPassword(pwdCharArray).build();
            redisClient = RedisClient.create((RedisURI)redisUri);
        }
        return redisClient;
    }
}

