/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.database.elastic;

import cn.warpin.core.database.elastic.ElasticSingleton;
import cn.warpin.core.database.elastic.params.ElasticCondition;
import cn.warpin.core.database.elastic.params.ElasticParams;
import cn.warpin.core.database.elastic.result.SearchResult;
import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.indices.DeleteIndexResponse;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.springframework.stereotype.Component;

@Component
public class ElasticOperate {
    private final ElasticsearchClient client = ElasticSingleton.getInstance().getClient();

    public <T> IndexResponse createOrUpdateDocument(ElasticParams<T> params) {
        try {
            IndexResponse firstResponse = this.client.index(i -> i.index(params.getIndex()).document(params.getDocument()));
            Object document = params.getDocument();
            Field idField = document.getClass().getDeclaredField("id");
            idField.setAccessible(true);
            idField.set(document, firstResponse.id());
            return this.client.index(i -> i.index(params.getIndex()).id(firstResponse.id()).document(document));
        }
        catch (Exception e) {
            throw new ResultException(ResCode.ELASTIC_CREATE_FAILED);
        }
    }

    public <T> SearchResult<T> searchDocuments(ElasticCondition<T> condition) {
        SearchResponse response = null;
        try {
            response = this.client.search(s -> {
                s.index(condition.getIndex(), new String[0]);
                if (condition.getFrom() != null && condition.getSize() != null) {
                    s.from(condition.getFrom());
                    s.size(condition.getSize());
                }
                return s.query(q -> q.bool(b -> {
                    if (condition.getQuery() != null && !condition.getQuery().isEmpty()) {
                        b.must(m -> m.queryString(qs -> qs.query(condition.getQuery())));
                    }
                    if (!(condition.getStartDate() == null || condition.getStartDate().isEmpty() || condition.getEndDate() == null || condition.getEndDate().isEmpty() || condition.getDateField() == null || condition.getDateField().isEmpty())) {
                        b.filter(f -> f.range(r -> r.field(condition.getDateField()).gte(JsonData.fromJson((String)condition.getStartDate())).lte(JsonData.fromJson((String)condition.getEndDate()))));
                    }
                    if (condition.getAdditionalQueries() != null) {
                        for (String additionalQuery : condition.getAdditionalQueries()) {
                            if (additionalQuery == null || additionalQuery.isEmpty()) continue;
                            b.must(m -> m.queryString(qs -> qs.query(additionalQuery)));
                        }
                    }
                    return b;
                }));
            }, condition.getClazz());
        }
        catch (IOException e) {
            throw new ResultException(ResCode.ELASTIC_CREATE_FAILED);
        }
        ArrayList<Object> results = new ArrayList<Object>();
        long totalHits = 0L;
        if (response.hits().total() != null) {
            totalHits = response.hits().total().value();
        }
        for (Hit hit : response.hits().hits()) {
            results.add(hit.source());
        }
        return new SearchResult(results, totalHits);
    }

    public DeleteResponse deleteDocument(String index, String id) {
        try {
            return this.client.delete(d -> d.index(index).id(id));
        }
        catch (IOException e) {
            throw new ResultException(ResCode.ELASTIC_DELETE_FAILED);
        }
    }

    public DeleteByQueryResponse deleteAllDocumentsInIndex(String index) {
        try {
            DeleteByQueryRequest request = new DeleteByQueryRequest.Builder().index(index, new String[0]).query(q -> q.matchAll(ma -> ma)).build();
            return this.client.deleteByQuery(request);
        }
        catch (IOException e) {
            throw new ResultException(ResCode.ELASTIC_DELETE_FAILED);
        }
    }

    public boolean deleteIndex(String index) {
        try {
            if (!this.indexExists(index)) {
                return false;
            }
            DeleteIndexResponse deleteResponse = this.client.indices().delete(d -> d.index(index, new String[0]));
            return deleteResponse.acknowledged();
        }
        catch (IOException e) {
            throw new ResultException(ResCode.ELASTIC_DELETE_FAILED);
        }
    }

    private boolean indexExists(String index) throws IOException {
        ExistsRequest request = new ExistsRequest.Builder().index(index, new String[0]).build();
        BooleanResponse response = this.client.indices().exists(request);
        return response.value();
    }
}

