/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.constant;

import java.util.Map;

public enum ApiList {
    TENCENT_ADDRESS_SERVICE("TENCENT_ADDRESS_SERVICE", "https://apis.map.qq.com/ws/geocoder/v1/"),
    TENCENT_WX_UPLOAD_SHIP_INFO("TENCENT_WX_UPLOAD_SHIP_INFO", "https://api.weixin.qq.com/wxa/sec/order/upload_shipping_info"),
    TENCENT_WX_ACCESS_TOKEN_GET("TENCENT_WX_ACCESS_TOKEN_GET", "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={appid}&secret={secret}"),
    TENCENT_GET_USER_INFO("GET_USER_INFO", "https://api.weixin.qq.com/cgi-bin/user/info?access_token={access_token}&openid={openid}&lang={lang}"),
    TENCENT_GET_JSAPI_TICKET("GET_JSAPI_TICKET", "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token={access_token}&type=jsapi"),
    TENCENT_GET_TEMPLATE_LIST("TENCENT_GET_TEMPLATE_LIST", "https://api.weixin.qq.com/cgi-bin/template/get_all_private_template?access_token={access_token}"),
    TENCENT_SEND_TEMPLATE_MESSAGE("SEND_TEMPLATE_MESSAGE", "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token={access_token}"),
    TENCENT_GET_OPENID("GET_OPENID", "https://api.weixin.qq.com/sns/oauth2/access_token?appid={appid}&secret={secret}&code={code}&grant_type=authorization_code"),
    TENCENT_GET_OAUTH_USER_INFO("GET_OAUTH_USER_INFO", "https://api.weixin.qq.com/sns/userinfo?access_token={access_token}&openid={openid}&lang={lang}"),
    PAYMENT_NOTIFY_URL("PAYMENT_NOTIFY_URL", "/bizcenter/order/callback"),
    ADAPAY_FAST_CARD_NOTIFY_URL("ADAPAY_FAST_CARD_NOTIFY_URL", "/tpcenter/userBank/callback"),
    ADAPAY_REFUND_NOTIFY_URL("ADAPAY_REFUND_NOTIFY_URL", "/bizcenter/orderRefundMain/callback"),
    CAS_REGISTER_SERVICE("CAS_REGISTER_SERVICE", "/v1/services"),
    CAS_GET_TGT_ST("CAS_GET_TGT", "/v1/tickets"),
    CAS_VALIDATE_ST("CAS_VALIDATE_ST", "/serviceValidate");

    private String key;
    private String value;

    private ApiList(String key, String value) {
        this.value = value;
        this.key = key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static String getValueByKey(String key) {
        for (ApiList s : ApiList.values()) {
            if (!s.getKey().equals(key)) continue;
            return s.getValue();
        }
        return "";
    }

    public static String getKeyByValue(String channelName) {
        for (ApiList s : ApiList.values()) {
            if (!channelName.equals(s.getValue())) continue;
            return s.getKey();
        }
        return "0";
    }

    public static String buildUrl(String key, Map<String, String> params) {
        String template = ApiList.getValueByKey(key);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String placeholder = "{" + entry.getKey() + "}";
            template = template.replace(placeholder, entry.getValue());
        }
        return template;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

