/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.config;

import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class EmailUtil {
    @Value(value="${spring.mail.from}")
    private String fromMail;
    @Value(value="${spring.mail.host}")
    private String host;
    @Value(value="${spring.mail.port}")
    private String port;
    @Resource
    private JavaMailSender mailSender;

    public void sendMessage(String from, String pwd, String to, String subject, String content) {
        if (StrUtil.isNotEmpty(from) && StrUtil.isNotEmpty(pwd)) {
            this.fromMail = from;
            this.mailSender = this.getMailSender(from, pwd);
        }
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "utf-8");
            helper.setFrom(this.fromMail);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        this.mailSender.send(mimeMessage);
    }

    public void sendMessage(String to, String subject, String content) {
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "utf-8");
            helper.setFrom(this.fromMail);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        this.mailSender.send(mimeMessage);
    }

    public void sendMessageCarryFiles(String to, String subject, String content, File[] files) {
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
            helper.setFrom(this.fromMail);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content);
            if (files != null && files.length > 0) {
                for (File file : files) {
                    helper.addAttachment(file.getName(), file);
                }
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        this.mailSender.send(mimeMessage);
    }

    public void sendMessageCarryFile(String to, String subject, String content, File file) {
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
            helper.setFrom(this.fromMail);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content);
            helper.addAttachment(file.getName(), file);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        this.mailSender.send(mimeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageCarryUrlAttachment(String to, String subject, String content, String fileUrl) {
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        File tempFile = null;
        try {
            int bytesRead;
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
            helper.setFrom(this.fromMail);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
            URL url = new URI(this.encodeUrl(fileUrl)).toURL();
            InputStream inputStream = url.openStream();
            Path tempFilePath = Files.createTempFile("attachment_", this.getFileExtension(fileUrl), new FileAttribute[0]);
            tempFile = tempFilePath.toFile();
            FileOutputStream outStream = new FileOutputStream(tempFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
            outStream.close();
            inputStream.close();
            String attachmentName = fileUrl.substring(fileUrl.lastIndexOf(47) + 1);
            helper.addAttachment(attachmentName, tempFile);
            this.mailSender.send(mimeMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    public JavaMailSenderImpl getMailSender(String userName, String password) {
        try {
            this.mailSender = new JavaMailSenderImpl();
            ((JavaMailSenderImpl)this.mailSender).setHost(this.host);
            ((JavaMailSenderImpl)this.mailSender).setUsername(userName);
            ((JavaMailSenderImpl)this.mailSender).setPassword(password);
            Properties pro = new Properties();
            pro.put("mail.smtp.ssl.enable", "true");
            pro.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            pro.put("mail.smtp.socketFactory.port", this.port);
            pro.put("mail.smtp.auth", "true");
            pro.put("mail.smtp.port", this.port);
            pro.put("mail.smtp.socketFactory.fallback", "false");
            ((JavaMailSenderImpl)this.mailSender).setJavaMailProperties(pro);
        }
        catch (Exception e) {
            throw new RuntimeException("\u90ae\u4ef6\u670d\u52a1\u5668\u521d\u59cb\u5316\u9519\u8bef!");
        }
        return (JavaMailSenderImpl)this.mailSender;
    }

    public String encodeUrl(String fileUrl) throws URISyntaxException {
        String[] pathSegments;
        URI baseUri = new URI(fileUrl);
        StringBuilder encodedPath = new StringBuilder();
        for (String segment : pathSegments = baseUri.getPath().split("/")) {
            if (segment.isEmpty()) continue;
            encodedPath.append("/");
            URI tempUri = new URI(null, null, null, -1, segment, null, null);
            encodedPath.append(tempUri.getRawPath());
        }
        URI encodedUri = new URI(baseUri.getScheme(), baseUri.getUserInfo(), baseUri.getHost(), baseUri.getPort(), encodedPath.toString(), baseUri.getRawQuery(), baseUri.getFragment());
        return encodedUri.toASCIIString();
    }

    private String getFileExtension(String fileName) {
        int lastIndexOf = fileName.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return fileName.substring(lastIndexOf);
    }

    public String getFromMail() {
        return this.fromMail;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    public void setFromMail(String fromMail) {
        this.fromMail = fromMail;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmailUtil)) {
            return false;
        }
        EmailUtil other = (EmailUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fromMail = this.getFromMail();
        String other$fromMail = other.getFromMail();
        if (this$fromMail == null ? other$fromMail != null : !this$fromMail.equals(other$fromMail)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        JavaMailSender this$mailSender = this.getMailSender();
        JavaMailSender other$mailSender = other.getMailSender();
        return !(this$mailSender == null ? other$mailSender != null : !this$mailSender.equals(other$mailSender));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmailUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fromMail = this.getFromMail();
        result = result * 59 + ($fromMail == null ? 43 : $fromMail.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        JavaMailSender $mailSender = this.getMailSender();
        result = result * 59 + ($mailSender == null ? 43 : $mailSender.hashCode());
        return result;
    }

    public String toString() {
        return "EmailUtil(fromMail=" + this.getFromMail() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", mailSender=" + String.valueOf(this.getMailSender()) + ")";
    }
}

