/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.config;

import cn.warpin.core.config.properties.AopProperties;
import jakarta.annotation.Resource;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;

public class AopConfig {
    @Resource
    private AopProperties aopProperties;

    public Advisor[] advisors() {
        return (Advisor[])this.aopProperties.getAspects().stream().map(aspect -> {
            AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
            pointcut.setExpression(aspect.getPointcut());
            return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.createAdvice(aspect.getAdvice(), aspect.getAdviceMethod()));
        }).toArray(Advisor[]::new);
    }

    private MethodInterceptor createAdvice(String adviceType, String adviceMethod) {
        return invocation -> {
            if ("before".equals(adviceType)) {
                System.out.println("Before advice logic from " + adviceMethod);
            }
            Object result = invocation.proceed();
            if ("after".equals(adviceType)) {
                System.out.println("After advice logic from " + adviceMethod);
            }
            return result;
        };
    }
}

