/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.base.tableConf.dao;

import cn.warpin.core.base.jpa.sql.SQLBuilder;
import cn.warpin.core.base.tableConf.bean.ColumnInfo;
import cn.warpin.core.base.tableConf.bean.TableInfo;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class TableConfRepository {
    @PersistenceContext
    private EntityManager entityManager;
    @Resource
    private SQLBuilder sqlBuilder;

    public List<TableInfo> queryAllTableInfo() {
        String sql = this.sqlBuilder.buildTableQuery();
        Query query = this.entityManager.createNativeQuery(sql.toString());
        List queryList = query.getResultList();
        if (ArrayUtil.isEmpty(queryList)) {
            return null;
        }
        ArrayList<TableInfo> resultList = new ArrayList<TableInfo>();
        for (Object[] objArr : queryList) {
            TableInfo tableInfo = new TableInfo(objArr);
            resultList.add(tableInfo);
        }
        return resultList;
    }

    public List<ColumnInfo> queryAllTableColumn() {
        String sql = this.sqlBuilder.buildColumnQuery();
        Query query = this.entityManager.createNativeQuery(sql);
        List queryList = query.getResultList();
        if (ArrayUtil.isEmpty(queryList)) {
            return null;
        }
        ArrayList<ColumnInfo> resultList = new ArrayList<ColumnInfo>();
        for (Object[] objArr : queryList) {
            ColumnInfo columnInfo = new ColumnInfo(objArr);
            String tableName = columnInfo.getTABLE_NAME();
            String cleanTableName = tableName.substring(tableName.indexOf("_") + 1);
            String targetClass = StrUtil.transformName(cleanTableName, true);
            String packageName = ObjectUtil.classFinder(targetClass);
            System.out.println("packageName ==============================> " + packageName);
            if (StrUtil.isEmpty(packageName)) continue;
            if (StrUtil.isEmpty(columnInfo.getTABLE_COMMENT())) {
                String tableComment = ObjectUtil.getClassTableComment(packageName);
                columnInfo.setTABLE_COMMENT(tableComment);
            }
            if (StrUtil.isEmpty(columnInfo.getCOLUMN_COMMENT())) {
                String fieldName = StrUtil.transformName(columnInfo.getCOLUMN_NAME(), false);
                String fieldComment = ObjectUtil.getFieldComment(packageName, fieldName);
                columnInfo.setCOLUMN_COMMENT(fieldComment);
            }
            resultList.add(columnInfo);
        }
        return resultList;
    }

    public static void main(String[] args) throws IOException {
        String packageName = "";
        String targetClass = "TestEntity";
        packageName = ObjectUtil.classFinder(targetClass);
        if (packageName != null && !packageName.isEmpty()) {
            System.out.println("Package name: " + packageName);
        } else {
            System.out.println("Class not found.");
        }
        String tableComment = ObjectUtil.getClassTableComment(packageName);
        System.out.println("Table Comment: " + tableComment);
        String fieldComment = ObjectUtil.getFieldComment(packageName, "testAge");
        System.out.println("Field Comment: " + fieldComment);
    }
}

