/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.base.jpa.sql;

import cn.warpin.core.base.jpa.jpaComment.enums.DbTypeEnum;
import cn.warpin.core.constant.Constants;
import jakarta.annotation.Resource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;

@Component
public class SQLBuilder {
    @Value(value="${attr.db-schema}")
    private String schema;
    @Resource
    private DataSource dataSource;

    private String getDatabaseType() {
        Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String string = metaData.getDatabaseProductName().toUpperCase();
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error accessing database metadata", e);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
    }

    public String buildColumnQuery() {
        Object sql;
        String schemaName = Constants.DB_NAME;
        String dbType = this.getDatabaseType();
        if (dbType.contains(DbTypeEnum.MYSQL.getValue())) {
            sql = "SELECT TABLE_NAME, COLUMN_NAME, COLUMN_COMMENT, DATA_TYPE FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = '" + schemaName + "' AND COLUMN_NAME NOT IN ('created_at','updated_at','created_by','updated_by','deleted_at')";
        } else if (dbType.contains(DbTypeEnum.POSTGRESQL.getValue())) {
            sql = "SELECT table_name, column_name, col_description(format('%I.%I', table_schema, table_name)::regclass, ordinal_position) as column_comment, data_type FROM information_schema.columns WHERE table_schema = 'public' AND column_name NOT IN ('created_at', 'updated_at', 'created_by', 'updated_by', 'deleted_at')";
        } else if (dbType.contains(DbTypeEnum.ORACLE.getValue())) {
            sql = "SELECT table_name, column_name, comments as column_comment, data_type FROM all_col_comments WHERE owner = '" + schemaName.toUpperCase() + "' AND column_name NOT IN ('created_at', 'updated_at', 'created_by', 'updated_by', 'deleted_at')";
        } else if (dbType.contains(DbTypeEnum.SQLSERVER.getValue())) {
            sql = "SELECT t.name AS table_name, c.name AS column_name, ep.value AS column_comment, ty.name AS data_type FROM sys.columns AS c JOIN sys.tables AS t ON c.object_id = t.object_id JOIN sys.types AS ty ON c.user_type_id = ty.user_type_id LEFT JOIN sys.extended_properties AS ep ON ep.major_id = t.object_id AND ep.minor_id = c.column_id AND ep.name = 'MS_Description' WHERE t.name NOT IN ('created_at', 'updated_at', 'created_by', 'updated_by', 'deleted_at')";
        } else {
            throw new IllegalArgumentException("Unsupported database type");
        }
        return sql;
    }

    public String buildTableQuery() {
        Object sql;
        String schemaName = Constants.DB_NAME;
        String dbType = this.getDatabaseType();
        if (dbType.contains(DbTypeEnum.MYSQL.getValue())) {
            sql = "SELECT TABLE_NAME, TABLE_COMMENT FROM information_schema.`TABLES` WHERE TABLE_SCHEMA ='" + schemaName + "'";
        } else if (dbType.contains(DbTypeEnum.POSTGRESQL.getValue())) {
            sql = "SELECT table_name, obj_description(to_regclass(table_name)::oid, 'pg_class') as table_comment FROM information_schema.tables WHERE table_schema = 'public'";
        } else if (dbType.contains(DbTypeEnum.ORACLE.getValue())) {
            sql = "SELECT table_name, comments as table_comment FROM all_tab_comments WHERE owner = '" + schemaName.toUpperCase() + "'";
        } else if (dbType.contains(DbTypeEnum.SQLSERVER.getValue())) {
            sql = "SELECT t.name AS table_name, ep.value AS table_comment FROM sys.tables AS t LEFT JOIN sys.extended_properties AS ep ON ep.major_id = t.object_id AND ep.minor_id = 0 AND ep.name = 'MS_Description' WHERE t.schema_id = SCHEMA_ID('" + schemaName + "')";
        } else {
            throw new IllegalArgumentException("Unsupported database type");
        }
        return sql;
    }

    public static String buildMetaDataQuerySql(String dbType, String dbName, String dbSchema, String tableName) {
        if (dbType.equals(DbTypeEnum.MYSQL.getValue())) {
            return SQLBuilder.mysqlMetadataSql(tableName, dbName);
        }
        if (dbType.equals(DbTypeEnum.POSTGRESQL.getValue())) {
            return SQLBuilder.postgreMetadataSql(tableName, dbSchema);
        }
        if (dbType.equals(DbTypeEnum.ORACLE.getValue())) {
            return SQLBuilder.oracleMetadataSql(tableName);
        }
        if (dbType.equals(DbTypeEnum.SQLSERVER.getValue())) {
            return SQLBuilder.sqlserverMetadataSql(tableName);
        }
        return null;
    }

    private static String mysqlMetadataSql(String tableName, String dbName) {
        return "SELECT \ncolumn_name AS column_name, \ndata_type AS data_type, \ncolumn_comment AS column_comment, \nis_nullable AS is_nullable, \ncharacter_maximum_length AS character_maximum_length, \nnumeric_precision AS numeric_precision,\nnumeric_scale AS numeric_scale,\ncolumn_key AS column_key\nFROM information_schema.COLUMNS \nWHERE TABLE_NAME = '" + tableName + "' AND TABLE_SCHEMA= '" + dbName + "'\nAND COLUMN_NAME != 'id' AND COLUMN_NAME != 'created_at' AND COLUMN_NAME != 'created_by' AND COLUMN_NAME != 'updated_at' AND COLUMN_NAME != 'updated_by' AND COLUMN_NAME != 'unique_tag' AND COLUMN_NAME != 'deleted_at'";
    }

    private static String postgreMetadataSql(String tableName, String dbSchema) {
        return "SELECT \n    c.column_name AS column_name,\n    c.udt_name AS data_type,\n    pg_catalog.col_description(pg_class.oid, c.ordinal_position) AS column_comment,\n    c.is_nullable AS is_nullable,\n    c.character_maximum_length AS character_maximum_length,\n    c.numeric_precision AS numeric_precision,\n    c.numeric_scale AS numeric_scale,\n    (SELECT CASE WHEN array_agg(con.contype::text) @> ARRAY['u'] THEN 'UNI' ELSE NULL END\n     FROM pg_catalog.pg_constraint con\n     WHERE con.conrelid = pg_class.oid\n       AND c.ordinal_position = ANY(con.conkey)\n       AND con.contype = 'u') AS column_key\nFROM \n    information_schema.columns c\nJOIN \n    pg_catalog.pg_class pg_class ON pg_class.relname = c.table_name\nJOIN \n    pg_catalog.pg_namespace n ON pg_class.relnamespace = n.oid AND n.nspname = c.table_schema\nWHERE \n    c.table_name = '" + tableName + "' AND \n    c.table_schema = '" + dbSchema + "' AND\n    c.column_name NOT IN ('id', 'created_at', 'created_by', 'updated_at', 'updated_by', 'unique_tag', 'deleted_at')\nORDER BY \n    c.ordinal_position;";
    }

    private static String oracleMetadataSql(String tableName) {
        return "";
    }

    private static String sqlserverMetadataSql(String tableName) {
        return "";
    }
}

