/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.core.base.jpa.jpaComment.config;

import cn.warpin.core.base.jpa.jpaComment.annotation.ColumnComment;
import cn.warpin.core.base.jpa.jpaComment.annotation.TableComment;
import cn.warpin.core.base.jpa.jpaComment.enums.DbTypeEnum;
import cn.warpin.core.base.jpa.jpaStrategy.CustomPhysicalNamingStrategy;
import cn.warpin.core.util.ObjectUtil;
import jakarta.annotation.Resource;
import jakarta.persistence.Column;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Table;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Set;
import org.hibernate.boot.model.naming.Identifier;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
public class DatabaseCommenter
implements ApplicationListener<ContextRefreshedEvent> {
    @Value(value="${attr.jpa-comment-update}")
    private Boolean jpaCommentUpdate;
    @Value(value="${attr.primary-db-name}")
    private String dbName;
    @PersistenceContext
    private EntityManager entityManager;
    @Resource
    private Environment environment;
    @Resource
    private PlatformTransactionManager transactionManager;
    @Resource
    private CustomPhysicalNamingStrategy namingStrategy;
    @Resource
    private JdbcTemplate jdbcTemplate;

    public void onApplicationEvent(@NotNull ContextRefreshedEvent event) {
        System.out.println("jpaCommentUpdate: " + this.jpaCommentUpdate);
        if (!this.jpaCommentUpdate.booleanValue()) {
            return;
        }
        String databaseType = this.getDatabaseType();
        this.printConsoleInfo(databaseType);
        try {
            if (DbTypeEnum.MYSQL.getValue().equalsIgnoreCase(databaseType)) {
                this.addMySQLComments();
            } else if (DbTypeEnum.POSTGRESQL.getValue().equalsIgnoreCase(databaseType)) {
                this.addPostgreSQLComments();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private String getDatabaseType() {
        String driverClassName = this.environment.getProperty("spring.datasource.driver-class-name");
        if (driverClassName == null) {
            throw new UnsupportedOperationException("Database driver class name is not configured");
        }
        return DbTypeEnum.fromDriverClassName(driverClassName).getValue();
    }

    private void addMySQLComments() throws SQLException {
        TransactionStatus transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            Metamodel metamodel = this.entityManager.getMetamodel();
            Set entities = metamodel.getEntities();
            for (EntityType entity : entities) {
                Class entityClass = entity.getJavaType();
                Table table = entityClass.getAnnotation(Table.class);
                if (table == null) continue;
                String tableName = table.name();
                String tableComment = this.getTableComment(entityClass);
                if (tableComment != null) {
                    this.entityManager.createNativeQuery(String.format("ALTER TABLE %s COMMENT = '%s'", tableName, tableComment)).executeUpdate();
                }
                for (Field field : ObjectUtil.getAllFields(entityClass)) {
                    String columnDefinition;
                    Column column = field.getAnnotation(Column.class);
                    if (column == null) continue;
                    String columnName = this.namingStrategy.toPhysicalColumnName(Identifier.toIdentifier((String)field.getName()), null).getText();
                    String columnComment = this.getColumnComment(field);
                    if (columnComment == null || (columnDefinition = this.getColumnDefinition(tableName, columnName)) == null) continue;
                    if (columnDefinition.contains("PRIMARY KEY")) {
                        columnDefinition = columnDefinition.replace("PRIMARY KEY", "").trim();
                    }
                    this.entityManager.createNativeQuery(String.format("ALTER TABLE %s MODIFY COLUMN %s %s COMMENT '%s'", tableName, columnName, columnDefinition, columnComment)).executeUpdate();
                }
            }
            this.transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            this.transactionManager.rollback(transactionStatus);
            throw new RuntimeException("Failed to add MySQL comments", e);
        }
    }

    private String getColumnDefinition(String tableName, String columnName) {
        try {
            String sql = String.format("SHOW COLUMNS FROM %s LIKE '%s'", tableName, columnName);
            return (String)this.jdbcTemplate.queryForObject(sql, (rs, rowNum) -> {
                String type = rs.getString("Type");
                String isNullable = rs.getString("Null");
                String defaultValue = rs.getString("Default");
                String extra = rs.getString("Extra");
                StringBuilder columnDefinition = new StringBuilder(type);
                if ("NO".equals(isNullable)) {
                    columnDefinition.append(" NOT NULL");
                }
                if (defaultValue != null) {
                    columnDefinition.append(" DEFAULT '").append(defaultValue).append("'");
                }
                if (extra != null && !extra.isEmpty()) {
                    columnDefinition.append(" ").append(extra);
                }
                return columnDefinition.toString();
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get column definition", e);
        }
    }

    private void addPostgreSQLComments() throws SQLException {
        TransactionStatus transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            Metamodel metamodel = this.entityManager.getMetamodel();
            Set entities = metamodel.getEntities();
            for (EntityType entity : entities) {
                Class entityClass = entity.getJavaType();
                Table table = entityClass.getAnnotation(Table.class);
                if (table == null) continue;
                String tableName = table.name();
                String tableComment = this.getTableComment(entityClass);
                if (tableComment != null) {
                    this.entityManager.createNativeQuery(String.format("COMMENT ON TABLE %s IS '%s'", tableName, tableComment)).executeUpdate();
                }
                for (Field field : ObjectUtil.getAllFields(entityClass)) {
                    Column column = field.getAnnotation(Column.class);
                    if (column == null) continue;
                    String columnName = this.namingStrategy.toPhysicalColumnName(Identifier.toIdentifier((String)field.getName()), null).getText();
                    String columnComment = this.getColumnComment(field);
                    if (columnComment == null) continue;
                    this.entityManager.createNativeQuery(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, columnComment)).executeUpdate();
                }
            }
            this.transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            this.transactionManager.rollback(transactionStatus);
            throw new RuntimeException("Failed to add PostgreSQL comments", e);
        }
    }

    private String getTableComment(Class<?> entityClass) {
        TableComment tableComment = entityClass.getAnnotation(TableComment.class);
        return tableComment != null ? tableComment.value() : null;
    }

    private String getColumnComment(Field field) {
        ColumnComment columnComment = field.getAnnotation(ColumnComment.class);
        return columnComment != null ? columnComment.value() : null;
    }

    private void printConsoleInfo(String databaseType) {
        System.out.printf("\n\u5f00\u59cb\u6267\u884c\u540c\u6b65\u8868\u5b57\u6bb5\u64cd\u4f5c....\n--------------------------------------\n\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5e93\u662f\uff1a%s\n\u6570\u636e\u5e93\u7c7b\u578b\u662f\uff1a%s\n--------------------------------------\n\n%n", this.dbName, databaseType);
    }
}

