package ${classPath};

import ${beanPkg};
import ${beanPkg}VO;
import ${daoPkg};
import ${conditionPkg};
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.BaseDao;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ObjectUtil;
import jakarta.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
* Summary : 业务实现类
*
* @Author ${author}
* @Create ${.now?string("yyyy-MM-dd HH:mm:ss")}
*/
@Service
@Transactional(rollbackFor = Exception.class)
public class ${uBeanName}Service {
	@Resource
	private ${uBeanName}Dao ${lBeanName}Dao;

	@Resource
	private BaseDao baseDao;

	@Resource
	private CommonService commonService;

	/**
	* 批量新增或修改${beanComment}
	* 字段值为null，会更新到数据库
	* @param in
	* @return
	*/
	public Result save(EditReq in) {
		List<Map<String, Object>> entities = (List<Map<String, Object>>) in.getEntities();
		for (Map<String, Object> ${lBeanName}VO : entities) {
			${uBeanName} ${lBeanName} = new ${uBeanName}();
			ObjectUtil.copyMapPropertiesToClass(${lBeanName}VO, ${lBeanName});
			${lBeanName}Dao.save(${lBeanName});
		}
		return Result.success();
	}

	/**
	* 批量更新${beanComment}
	* 字段值为null，会更新到数据库
	* @param in
	* @return
	*/
	public Result update(EditReq in) {
		List<Map<String, Object>> entities = (List<Map<String, Object>>) in.getEntities();
		for (Map<String, Object> ${lBeanName}VO : entities) {
			${uBeanName} ${lBeanName} = new ${uBeanName}();
			ObjectUtil.copyMapPropertiesToClass(${lBeanName}VO, ${lBeanName});
			baseDao.update("${uBeanName}", ${lBeanName}, "id");
		}
		return Result.success();
	}

	/**
	* 批量删除${beanComment}
	* @param in
	* @return
	*/
	public Result delete(EditReq in) {
		List<Map<String, Object>> entities = (List<Map<String, Object>>) in.getEntities();
		for (Map<String, Object> ${lBeanName}VO : entities) {
			${uBeanName} ${lBeanName} = new ${uBeanName}();
			ObjectUtil.copyMapPropertiesToClass(${lBeanName}VO, ${lBeanName});
			${lBeanName}Dao.delete(${lBeanName});
		}
		return Result.success();
	}

	/**
	* 查询${beanComment}
	* @param condition
	* @return
	*/
	public Result query(QueryCondition condition) {
		${uBeanName}Condition ${lBeanName}Condition = new ${uBeanName}Condition();
		Map<String, Object> entity = (Map<String, Object>) condition.getEntity();
		ObjectUtil.copyMapPropertiesToClass(entity, ${lBeanName}Condition);
		condition.setEntity(${lBeanName}Condition);
		Map<String, Object> voClassMap = ObjectUtil.getVOClassMap(${lBeanName}Condition);
		return commonService.queryVO(condition, ${uBeanName}VO.class, voClassMap);
	}


}


