package ${classPath};

import cn.warpin.core.base.baseEntity.BaseEntity;
import cn.warpin.core.base.jpa.jpaComment.annotation.ColumnComment;
import cn.warpin.core.base.jpa.jpaComment.annotation.TableComment;
import com.fasterxml.jackson.annotation.JsonFormat;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.*;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

/**
* Summary : ${classComment}实体类信息
*
* @author ${author}
* @create ${.now?string("yyyy-MM-dd HH:mm:ss")}
*/
@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "${tableName}")
@TableComment("${classComment}")
public class ${className} extends BaseEntity {

<#-- 定义宏用于生成@Column注解 -->
<#macro generateColumnAnnotation property>
    <#if property.size?? && property.size != 0>
		@Column(length = ${property.size}<#if property.columnKey?? && property.columnKey == "UNI">, unique = true</#if>, columnDefinition = "${property.columnType}")
    <#elseif property.numericPrecision?? && property.numericScale??>
		@Column(precision = ${property.numericPrecision}, scale = ${property.numericScale}<#if property.columnKey?? && property.columnKey == "UNI">, unique = true</#if>, columnDefinition = "${property.columnType}")
    <#else>
		@Column(columnDefinition = "${property.columnType}"<#if property.isUnique?? && property.isUnique>, unique = true</#if>)
    </#if>
</#macro>

<#list properties as property>
	@ColumnComment("${property.columnComment}")
    <#if property.columnType=="date">
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    <#elseif property.columnType == "datetime" || property.columnType == "timestamp">
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    <#elseif property.columnType=="varchar">
    <#else>
    </#if>
<#--    ${generateColumnAnnotation(property)}  &lt;#&ndash; 调用宏来生成@Column注解 &ndash;&gt;-->
<#-- 配置开始的注解和首个参数前括号 -->
    <#assign columnParams = []>
    <#if property.length?? && property.length != 0 && property.length != 255 && (property.columnType != "text" && property.columnType != "longtext")>
        <#assign columnParams = columnParams + ["length = " + property.length]>
    </#if>
    <#if property.numericPrecision?? && property.numericPrecision != 0>
        <#assign columnParams = columnParams + ["precision = " + property.numericPrecision]>
    </#if>
    <#if property.numericScale?? && property.numericScale != 0>
        <#assign columnParams = columnParams + ["scale = " + property.numericScale]>
    </#if>
    <#if property.columnKey?? && property.columnKey == "UNI">
        <#assign columnParams = columnParams + ["unique = true"]>
    </#if>
    <#if (property.columnType == "text" || property.columnType == "longtext")>
        <#assign columnParams = columnParams + ["columnDefinition = \"" + property.columnType + "\""]>
    </#if>
	@Column(${columnParams?join(", ")})
	private ${property.propertyType} ${property.propertyName};

</#list>

}
