/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.common.generateCode.dbInstance;

import cn.warpin.core.base.jpa.jpaComment.enums.DbTypeEnum;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;

public class DBInstance {
    private Connection connection;
    private String dbType;
    private String ipLocal;
    private String port;
    private String dbName;
    private String userName;
    private String password;

    public DBInstance(String dbType, String ipLocal, String port, String dbName, String userName, String password) {
        this.dbType = dbType;
        this.ipLocal = ipLocal;
        this.port = port;
        this.dbName = dbName;
        this.userName = userName;
        this.password = password;
    }

    public Connection getConnection() {
        if (this.dbType.equals(DbTypeEnum.MYSQL.getValue())) {
            return this.getMySqlConnection();
        }
        if (this.dbType.equals(DbTypeEnum.POSTGRESQL.getValue())) {
            return this.getPostgreSqlConnection();
        }
        if (this.dbType.equals(DbTypeEnum.ORACLE.getValue())) {
            return this.getOracleSqlConnection();
        }
        if (this.dbType.equals(DbTypeEnum.SQLSERVER.getValue())) {
            return this.getSqlServerConnection();
        }
        return null;
    }

    private Connection getMySqlConnection() {
        if (Objects.nonNull(this.connection)) {
            return this.connection;
        }
        String jdbcUrl = "jdbc:mysql://" + this.ipLocal + ":" + this.port + "/" + this.dbName + "?useUnicode=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai";
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            this.connection = DriverManager.getConnection(jdbcUrl, this.userName, this.password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.connection;
    }

    private Connection getPostgreSqlConnection() {
        if (Objects.nonNull(this.connection)) {
            return this.connection;
        }
        String jdbcUrl = "jdbc:postgresql://" + this.ipLocal + ":" + this.port + "/" + this.dbName + "?useUnicode=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai";
        try {
            Class.forName("org.postgresql.Driver");
            this.connection = DriverManager.getConnection(jdbcUrl, this.userName, this.password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.connection;
    }

    private Connection getOracleSqlConnection() {
        if (Objects.nonNull(this.connection)) {
            return this.connection;
        }
        String jdbcUrl = "jdbc:oracle:thin:@" + this.ipLocal + ":" + this.port + ":" + this.dbName;
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            this.connection = DriverManager.getConnection(jdbcUrl, this.userName, this.password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.connection;
    }

    private Connection getSqlServerConnection() {
        if (Objects.nonNull(this.connection)) {
            return this.connection;
        }
        String jdbcUrl = "jdbc:sqlserver://" + this.ipLocal + ":" + this.port + ";databaseName=" + this.dbName + ";integratedSecurity=true;";
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            this.connection = DriverManager.getConnection(jdbcUrl, this.userName, this.password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.connection;
    }

    public void closeConnection() {
        if (Objects.isNull(this.connection)) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            throw new RuntimeException(sqlException);
        }
        finally {
            this.connection = null;
        }
    }
}

