/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.common.generateCode;

import cn.warpin.common.generateCode.ColumnInfo;
import cn.warpin.common.generateCode.FreeMarker;
import cn.warpin.common.generateCode.GenConst;
import cn.warpin.common.generateCode.GenUtils;
import cn.warpin.common.generateCode.PathBuilder;
import cn.warpin.common.generateCode.bean.PropertyBean;
import cn.warpin.common.generateCode.dbInstance.DBInstance;
import cn.warpin.core.base.jpa.jpaComment.enums.DbTypeEnum;
import cn.warpin.core.base.jpa.sql.SQLBuilder;
import cn.warpin.core.util.FileUtil;
import cn.warpin.core.util.StrUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class GenerateApplication {
    private static final String AUTHOR = "gyq";
    private static String TABLE_PREFIX = "sys_";
    private static final String MODULE = "syscenter";
    private static final String FEATURE = "department";
    private static final String FEATURE_COMMENT = "\u90e8\u95e8\u4fe1\u606f";
    private static final String CLASS_PATH = "src/main/java/com/warpin/business/";
    private static final String BASE_PKG = "cn.warpin.business";
    private static final String BEAN = "bean";
    private static final String CONTROLLER = "controller";
    private static final String DAO = "dao";
    private static final String PARAMS = "params";
    private static final String SERVICE = "service";
    DBInstance dbInstance = new DBInstance(DbTypeEnum.MYSQL.getValue(), "192.168.0.102", "3306", "zg-platform-db", "root", "serveradmin");

    public static void main(String[] args) {
        GenerateApplication gff = new GenerateApplication();
        gff.genBean();
        gff.genParams();
        gff.genDao();
        gff.genService();
        gff.genController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genBean() {
        List<ColumnInfo> columnInfos = this.getColumnInfoList();
        Configuration configuration = FreeMarker.getConfiguration();
        Writer out = null;
        try {
            String pkg = "cn.warpin.business.syscenter.department";
            String beanPkg = pkg + ".bean";
            String beanName = GenUtils.upperCaseFirstName(FEATURE);
            String fileName = beanName + ".java";
            String filePath = PathBuilder.getSubModulePath(MODULE, FEATURE, BEAN);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("classPath", beanPkg);
            String tableName = TABLE_PREFIX + GenUtils.upperCharToUnderLine(FEATURE);
            dataMap.put("tableName", tableName);
            dataMap.put("classComment", FEATURE_COMMENT);
            dataMap.put("className", beanName);
            dataMap.put("author", AUTHOR);
            ArrayList<PropertyBean> properties = new ArrayList<PropertyBean>();
            for (ColumnInfo columnInfo : columnInfos) {
                PropertyBean property = new PropertyBean(columnInfo.getName(), columnInfo.getType(), columnInfo.getColumnKey(), columnInfo.getComment(), GenUtils.transformType(columnInfo.getType()), StrUtil.transformName((String)columnInfo.getName(), (boolean)false), columnInfo.getNumericPrecision(), columnInfo.getNumericScale(), columnInfo.getSize());
                properties.add(property);
            }
            dataMap.put("properties", properties);
            if (!FileUtil.checkFileExist((String)filePath, (String)fileName).booleanValue()) {
                Template template = configuration.getTemplate("bean.ftl");
                String path = FileUtil.createFile((String)filePath, (String)fileName);
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path)));
                template.process(dataMap, out);
                System.out.println("-----------------> " + fileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f !");
            } else {
                System.out.println("-----------------> " + fileName + " \u6587\u4ef6\u672a\u521b\u5efa\uff0c\u6587\u4ef6\u5df2\u5b58\u5728 !");
            }
            fileName = beanName + "VO.java";
            if (!FileUtil.checkFileExist((String)filePath, (String)fileName).booleanValue()) {
                Template templateVo = configuration.getTemplate("beanVO.ftl");
                String voPath = FileUtil.createFile((String)filePath, (String)fileName);
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(voPath)));
                templateVo.process(dataMap, out);
                System.out.println("-----------------> " + fileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f !");
            } else {
                System.out.println("-----------------> " + fileName + " \u6587\u4ef6\u672a\u521b\u5efa\uff0c\u6587\u4ef6\u5df2\u5b58\u5728 !");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != out) {
                    out.flush();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genParams() {
        Configuration configuration = FreeMarker.getConfiguration();
        Writer out = null;
        try {
            String pkg = "cn.warpin.business.syscenter.department";
            String paramPkg = pkg + ".params";
            String beanName = GenUtils.upperCaseFirstName(FEATURE);
            String beanPkg = pkg + ".bean." + beanName;
            String className = beanName + "Condition";
            String fileName = beanName + "Condition.java";
            String filePath = PathBuilder.getSubModulePath(MODULE, FEATURE, PARAMS);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("classPath", paramPkg);
            dataMap.put("beanPkg", beanPkg);
            dataMap.put("className", className);
            dataMap.put("beanName", beanName);
            dataMap.put("lBeanName", GenUtils.lowerCaseFirstName(beanName));
            String pkgName = GenUtils.lowerCaseFirstName(beanName);
            pkgName = GenUtils.upperCharToUnderLine(pkgName);
            dataMap.put("pkg", TABLE_PREFIX + pkgName);
            dataMap.put("author", AUTHOR);
            if (!FileUtil.checkFileExist((String)filePath, (String)fileName).booleanValue()) {
                Template template = configuration.getTemplate("condition.ftl");
                String path = FileUtil.createFile((String)filePath, (String)fileName);
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path)));
                template.process(dataMap, out);
                System.out.println("-----------------> " + fileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f !");
            } else {
                System.out.println("-----------------> " + fileName + " \u6587\u4ef6\u672a\u521b\u5efa\uff0c\u6587\u4ef6\u5df2\u5b58\u5728 !");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != out) {
                    out.flush();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genDao() {
        Configuration configuration = FreeMarker.getConfiguration();
        Writer out = null;
        try {
            String pkg = "cn.warpin.business.syscenter.department";
            String daoPkg = pkg + ".dao";
            String beanName = GenUtils.upperCaseFirstName(FEATURE);
            String beanPkg = pkg + ".bean." + beanName;
            String className = beanName + "Dao";
            String fileName = beanName + "Dao.java";
            String filePath = PathBuilder.getSubModulePath(MODULE, FEATURE, DAO);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("classPath", daoPkg);
            dataMap.put("beanPkg", beanPkg);
            dataMap.put("className", className);
            dataMap.put("beanName", beanName);
            dataMap.put("author", AUTHOR);
            if (!FileUtil.checkFileExist((String)filePath, (String)fileName).booleanValue()) {
                Template template = configuration.getTemplate("dao.ftl");
                String path = FileUtil.createFile((String)filePath, (String)fileName);
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path)));
                template.process(dataMap, out);
                System.out.println("-----------------> " + fileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f !");
            } else {
                System.out.println("-----------------> " + fileName + " \u6587\u4ef6\u672a\u521b\u5efa\uff0c\u6587\u4ef6\u5df2\u5b58\u5728 !");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != out) {
                    out.flush();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genService() {
        Configuration configuration = FreeMarker.getConfiguration();
        Writer out = null;
        try {
            String pkg = "cn.warpin.business.syscenter.department";
            String servicePkg = pkg + ".service";
            String uBeanName = GenUtils.upperCaseFirstName(FEATURE);
            String lBeanName = GenUtils.lowerCaseFirstName(FEATURE);
            String beanPkg = pkg + ".bean." + uBeanName;
            String daoPkg = pkg + ".dao." + uBeanName + "Dao";
            String fileName = uBeanName + "Service.java";
            String filePath = PathBuilder.getSubModulePath(MODULE, FEATURE, SERVICE);
            String conditionPkg = pkg + ".params." + uBeanName + "Condition";
            String beanComment = FEATURE_COMMENT;
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("classPath", servicePkg);
            dataMap.put("beanPkg", beanPkg);
            dataMap.put("daoPkg", daoPkg);
            dataMap.put("conditionPkg", conditionPkg);
            dataMap.put("author", AUTHOR);
            dataMap.put("uBeanName", uBeanName);
            dataMap.put("lBeanName", lBeanName);
            dataMap.put("beanComment", beanComment);
            if (!FileUtil.checkFileExist((String)filePath, (String)fileName).booleanValue()) {
                Template template = configuration.getTemplate("service.ftl");
                String path = FileUtil.createFile((String)filePath, (String)fileName);
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path)));
                template.process(dataMap, out);
                System.out.println("-----------------> " + fileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f !");
            } else {
                System.out.println("-----------------> " + fileName + " \u6587\u4ef6\u672a\u521b\u5efa\uff0c\u6587\u4ef6\u5df2\u5b58\u5728 !");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != out) {
                    out.flush();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genController() {
        Configuration configuration = FreeMarker.getConfiguration();
        Writer out = null;
        try {
            String pkg = "cn.warpin.business.syscenter.department";
            String ctlPkg = pkg + ".controller";
            String uBeanName = GenUtils.upperCaseFirstName(FEATURE);
            String lBeanName = GenUtils.lowerCaseFirstName(FEATURE);
            String servicePkg = pkg + ".service." + uBeanName + "Service";
            String fileName = uBeanName + "Controller.java";
            String filePath = PathBuilder.getSubModulePath(MODULE, FEATURE, CONTROLLER);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("classPath", ctlPkg);
            dataMap.put("module", MODULE);
            dataMap.put("servicePkg", servicePkg);
            dataMap.put("author", AUTHOR);
            dataMap.put("uBeanName", uBeanName);
            dataMap.put("lBeanName", lBeanName);
            dataMap.put("beanComment", FEATURE_COMMENT);
            if (!FileUtil.checkFileExist((String)filePath, (String)fileName).booleanValue()) {
                Template template = configuration.getTemplate("controller.ftl");
                String path = FileUtil.createFile((String)filePath, (String)fileName);
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path)));
                template.process(dataMap, out);
                System.out.println("-----------------> " + fileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f !");
            } else {
                System.out.println("-----------------> " + fileName + " \u6587\u4ef6\u672a\u521b\u5efa\uff0c\u6587\u4ef6\u5df2\u5b58\u5728 !");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != out) {
                    out.flush();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private List<ColumnInfo> getColumnInfoList() {
        Connection connection = this.dbInstance.getConnection();
        if (connection == null) {
            throw new RuntimeException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3a\u7a7a");
        }
        String TABLE_NAME = TABLE_PREFIX + GenUtils.upperCharToUnderLine(FEATURE);
        String sql = SQLBuilder.buildMetaDataQuerySql((String)GenConst.DB_TYPE, (String)"zg-platform-db", (String)"public", (String)TABLE_NAME);
        PreparedStatement preparedStatement = null;
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        try {
            preparedStatement = connection.prepareStatement(sql);
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                ColumnInfo columnInfo = ColumnInfo.builder().name(rs.getString("column_name")).type(rs.getString("data_type").toLowerCase()).comment(rs.getString("column_comment")).isNullable("YES".equals(rs.getString("is_nullable"))).columnKey(rs.getString("column_key")).size(rs.getLong("character_maximum_length")).numericPrecision(rs.getInt("numeric_precision")).numericScale(rs.getInt("numeric_scale")).build();
                list.add(columnInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                if (Objects.nonNull(preparedStatement)) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    static {
        if (StrUtil.isEmpty((String)TABLE_PREFIX)) {
            TABLE_PREFIX = "sys_";
        }
    }
}

