/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.common.generateCode;

import cn.warpin.common.generateCode.GenConst;
import cn.warpin.common.generateCode.JavaFilePath;
import cn.warpin.core.util.StrUtil;
import com.sun.source.doctree.DocTree;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenUtils {
    public static String upperCaseFirstName(String str) {
        char[] cs = str.toCharArray();
        if (Character.isUpperCase(cs[0])) {
            return str;
        }
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public static String lowerCaseFirstName(String str) {
        char[] cs = str.toCharArray();
        if (Character.isLowerCase(cs[0])) {
            return str;
        }
        cs[0] = (char)(cs[0] + 32);
        return String.valueOf(cs);
    }

    public static String upperCharToUnderLine(String param) {
        Pattern p = Pattern.compile("[A-Z]");
        if (param == null || param.equals("")) {
            return "";
        }
        StringBuilder builder = new StringBuilder(param);
        Matcher mc = p.matcher(param);
        int i = 0;
        while (mc.find()) {
            builder.replace(mc.start() + i, mc.end() + i, "_" + mc.group().toLowerCase());
            ++i;
        }
        if ('_' == builder.charAt(0)) {
            builder.deleteCharAt(0);
        }
        return builder.toString();
    }

    public static String transformTableName(String tableName, boolean upCaseFirst) {
        String name = "";
        int index = tableName.toString().indexOf(95);
        if (index != -1) {
            name = tableName.toString().substring(index + 1);
        }
        return StrUtil.transformName((String)name, (boolean)upCaseFirst);
    }

    public static StringBuilder getRetrieveMethodInfo() {
        StringBuilder methodInfo = new StringBuilder();
        methodInfo.append("\t").append("/**").append("\n");
        methodInfo.append("\t").append(" * \u67e5\u8be2").append("\n");
        methodInfo.append("\t").append(" *").append("\n");
        methodInfo.append("\t").append(" * @param id").append(" \u4e3b\u952eid \n");
        methodInfo.append("\t").append(" * @return entity").append("\n");
        methodInfo.append("\t").append(" */").append("\n");
        return methodInfo;
    }

    public static StringBuilder getListMethodInfo(String paramName) {
        StringBuilder methodInfo = new StringBuilder();
        methodInfo.append("\t").append("/**").append("\n");
        methodInfo.append("\t").append(" * \u67e5\u8be2\u5217\u8868\u6216\u5355\u6761").append("\n");
        methodInfo.append("\t").append(" *").append("\n");
        methodInfo.append("\t").append(" * @param condition").append(" \u67e5\u8be2\u6761\u4ef6 \n");
        methodInfo.append("\t").append(" * @return \u5217\u8868\u7ed3\u679c\u96c6").append("\n");
        methodInfo.append("\t").append(" */").append("\n");
        return methodInfo;
    }

    public static StringBuilder getListExtMethodInfo(String paramName) {
        StringBuilder methodInfo = new StringBuilder();
        methodInfo.append("\t").append("/**").append("\n");
        methodInfo.append("\t").append(" * \u67e5\u8be2\u5217\u8868\u4ee5\u53ca\u6269\u5c55\u4fe1\u606f").append("\n");
        methodInfo.append("\t").append(" *").append("\n");
        methodInfo.append("\t").append(" * @param condition").append(" \u67e5\u8be2\u6761\u4ef6 \n");
        methodInfo.append("\t").append(" * @return \u5217\u8868\u7ed3\u679c\u96c6").append("\n");
        methodInfo.append("\t").append(" */").append("\n");
        return methodInfo;
    }

    public static StringBuilder getDeleteMethodInfo() {
        StringBuilder methodInfo = new StringBuilder();
        methodInfo.append("\t").append("/**").append("\n");
        methodInfo.append("\t").append(" * \u5220\u9664").append("\n");
        methodInfo.append("\t").append(" *").append("\n");
        methodInfo.append("\t").append(" * @param id").append(" \u4e3b\u952eid \n");
        methodInfo.append("\t").append(" * @return \u5220\u9664\u6210\u529f").append("\n");
        methodInfo.append("\t").append(" */").append("\n");
        return methodInfo;
    }

    public static StringBuilder getCreateAndUpdateMethodInfo(String desc, String paramName) {
        StringBuilder methodInfo = new StringBuilder();
        methodInfo.append("\t").append("/**").append("\n");
        methodInfo.append("\t").append(" * ").append(desc).append("\n");
        methodInfo.append("\t").append(" *").append("\n");
        methodInfo.append("\t").append(" * @param ").append(paramName).append(" entity \n");
        methodInfo.append("\t").append(" * @return entity").append("\n");
        methodInfo.append("\t").append(" */").append("\n");
        return methodInfo;
    }

    public static JavaFilePath creteAndGetFileInfo(String packageName, String filePath, String fileContent) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
        } else {
            throw new IOException("\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u521b\u5efa\u5931\u8d25=>" + filePath);
        }
        file.createNewFile();
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.println(fileContent);
        printWriter.close();
        int beginIndex = filePath.indexOf(GenUtils.packageName2FilePath(packageName));
        String classPath = filePath.substring(beginIndex);
        JavaFilePath javaFilePath = JavaFilePath.builder().filePath(filePath).classPath(classPath).build();
        return javaFilePath;
    }

    public static StringBuilder getCreateInfo() {
        StringBuilder createInfo = new StringBuilder();
        createInfo.append("/**").append("\n");
        createInfo.append(" * Summary : ").append("\n");
        createInfo.append(" *").append("\n");
        createInfo.append(" * @author ").append((Object)DocTree.Kind.AUTHOR).append("\n");
        createInfo.append(" * @create ").append(GenConst.CREATE).append("\n");
        createInfo.append(" */").append("\n");
        return createInfo;
    }

    public static String packageName2FilePath(String packageName) {
        return packageName.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
    }

    public static String transformType(String type) {
        String javaType = "Object";
        switch (type.toLowerCase()) {
            case "int": 
            case "tinyint": 
            case "smallint": 
            case "mediumint": 
            case "bigint": {
                javaType = "Integer";
                break;
            }
            case "varchar": 
            case "char": 
            case "text": 
            case "tinytext": 
            case "longtext": {
                javaType = "String";
                break;
            }
            case "blob": {
                javaType = "Byte[]";
                break;
            }
            case "bit": {
                javaType = "Boolean";
                break;
            }
            case "decimal": {
                javaType = "BigDecimal";
                break;
            }
            case "double": {
                javaType = "Double";
                break;
            }
            case "float": {
                javaType = "Float";
                break;
            }
            case "timestamp": 
            case "datetime": {
                javaType = "Timestamp";
                break;
            }
            case "date": {
                javaType = "Date";
                break;
            }
        }
        return javaType;
    }
}

