/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.usercenter.user.service;

import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.warpin.business.usercenter.user.bean.User;
import cn.warpin.business.usercenter.user.bean.UserVO;
import cn.warpin.business.usercenter.user.dao.UserDao;
import cn.warpin.business.usercenter.user.params.UserCondition;
import cn.warpin.business.usercenter.user.params.UserSubmit;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.BaseDao;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.constant.EnumStore;
import cn.warpin.core.database.redis.RedisOperate;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import cn.warpin.core.security.jwt.JwtUtils;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.CryptoUtil;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import cn.warpin.thirdPart.tencent.wx.miniapp.WxMiniAction;
import cn.warpin.thirdPart.tencent.wx.miniapp.WxRegisterInfo;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class UserService {
    @Resource
    private UserDao userDao;
    @Resource
    private BaseDao baseDao;
    @Resource
    private CommonService commonService;

    public Result save(EditReq in) {
        List entities = in.getEntities();
        for (Map userVO : entities) {
            User user = new User();
            if (null == user.getId()) {
                user.setUuid(StrUtil.uuid32());
            }
            ObjectUtil.copyMapPropertiesToClass((Map)userVO, (Object)((Object)user));
            this.userDao.save((Object)user);
        }
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        for (Map userVO : entities) {
            User user = new User();
            ObjectUtil.copyMapPropertiesToClass((Map)userVO, (Object)((Object)user));
            this.baseDao.update("User", (Object)user, "id");
        }
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map userVO : entities) {
            User user = new User();
            ObjectUtil.copyMapPropertiesToClass((Map)userVO, (Object)((Object)user));
            this.userDao.delete((Object)user);
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        UserCondition userCondition = new UserCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)userCondition));
        condition.setEntity((Object)userCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)userCondition));
        Result result = this.commonService.queryVO(condition, UserVO.class, voClassMap);
        return result;
    }

    public Result getPhoneLogin(WxRegisterInfo info) {
        WxMaPhoneNumberInfo phoneNumberInfo = WxMiniAction.phone((WxRegisterInfo)info);
        List<User> users = this.userDao.findByTel(phoneNumberInfo.getPhoneNumber());
        User user = null;
        if (ArrayUtil.isEmpty(users)) {
            user = new User(phoneNumberInfo.getPhoneNumber());
            user.setAccount(phoneNumberInfo.getPhoneNumber());
            user.setUuid(StrUtil.uuid32());
            user.setUniqueTag(StrUtil.uuid32());
            this.userDao.save((Object)user);
        } else {
            user = users.get(0);
        }
        String token = JwtUtils.createToken((String)EnumStore.LOGIN_TYPE_USER.getKey(), (String)user.getAccount(), (String)user.getUuid());
        System.out.println("token = " + token);
        UserVO userVO = new UserVO();
        BeanUtils.copyProperties((Object)((Object)user), (Object)((Object)userVO));
        userVO.setToken(token);
        return Result.success((Object)((Object)userVO));
    }

    public Result login(UserSubmit userSubmit) {
        User user = null;
        List<User> users = this.userDao.findByTel(userSubmit.getTel());
        if (ArrayUtil.isEmpty(users)) {
            user = new User(userSubmit.getTel());
            user.setAccount(userSubmit.getTel());
            user.setUuid(StrUtil.uuid32());
            user.setUniqueTag(StrUtil.uuid32());
            this.userDao.save((Object)user);
        } else {
            user = users.get(0);
            if (userSubmit.getLoginType().equals("1")) {
                Result smsResult = this.checkSmsCode(user.getTel(), userSubmit.getSmsCode());
                if (!smsResult.getCode().equals(ResCode.SUCCESS.getKey())) {
                    return smsResult;
                }
            } else {
                String originPwd = user.getPassword();
                String password = CryptoUtil.encode((String)userSubmit.getPassword());
                if (!password.equals(originPwd)) {
                    return Result.fail((ResCode)ResCode.INCORRECT_PWD, (String)"\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u6b63\u786e");
                }
            }
        }
        String token = JwtUtils.createToken((String)EnumStore.LOGIN_TYPE_USER.getKey(), (String)user.getAccount(), (String)user.getUuid());
        UserVO userVO = new UserVO();
        BeanUtils.copyProperties((Object)((Object)user), (Object)((Object)userVO));
        userVO.setToken(token);
        return Result.success((Object)((Object)userVO));
    }

    private Result checkSmsCode(String tel, String code) {
        String key = "SMS_SENT_" + tel;
        String storeCode = RedisOperate.getValue((String)key);
        if (!storeCode.equals(code)) {
            return Result.fail((ResCode)ResCode.SMS_CODE_INCORRECT);
        }
        return Result.success();
    }
}

