/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.usercenter.address.service;

import cn.warpin.business.usercenter.address.bean.Address;
import cn.warpin.business.usercenter.address.bean.AddressVO;
import cn.warpin.business.usercenter.address.dao.AddressDao;
import cn.warpin.business.usercenter.address.params.AddressCondition;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.BaseDao;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ObjectUtil;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class AddressService {
    @Resource
    private AddressDao addressDao;
    @Resource
    private BaseDao baseDao;
    @Resource
    private CommonService commonService;

    public Result save(EditReq in) {
        List entities = in.getEntities();
        boolean reset = false;
        ArrayList<Address> addresses = new ArrayList<Address>();
        Integer userId = null;
        for (Map addressVO : entities) {
            Address address = new Address();
            ObjectUtil.copyMapPropertiesToClass((Map)addressVO, (Object)((Object)address));
            userId = address.getUserId();
            if (null != addressVO.get("useState") && "1".equals(addressVO.get("useState").toString())) {
                reset = true;
            }
            addresses.add(address);
        }
        if (reset) {
            Address setUseStateNo = new Address("0", userId);
            this.baseDao.update("Address", (Object)setUseStateNo, "userId");
        }
        this.addressDao.saveAll(addresses);
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        boolean reset = false;
        ArrayList<Address> addresses = new ArrayList<Address>();
        Integer userId = null;
        for (Map addressVO : entities) {
            Address address = new Address();
            ObjectUtil.copyMapPropertiesToClass((Map)addressVO, (Object)((Object)address));
            userId = address.getUserId();
            if (null != addressVO.get("useState") && "1".equals(addressVO.get("useState").toString())) {
                reset = true;
            }
            addresses.add(address);
        }
        if (reset) {
            Address setUseStateNo = new Address("0", userId);
            this.baseDao.update("Address", (Object)setUseStateNo, "userId");
        }
        this.addressDao.saveAll(addresses);
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map addressVO : entities) {
            Address address = new Address();
            ObjectUtil.copyMapPropertiesToClass((Map)addressVO, (Object)((Object)address));
            this.addressDao.delete((Object)address);
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        AddressCondition addressCondition = new AddressCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)addressCondition));
        condition.setEntity((Object)addressCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)addressCondition));
        Result result = this.commonService.queryVO(condition, AddressVO.class, voClassMap);
        return result;
    }
}

