/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.tableConf.service;

import cn.warpin.business.syscenter.tableConf.dao.TableConfDao;
import cn.warpin.business.syscenter.tableConf.params.TableConfCondition;
import cn.warpin.core.base.condition.BaseCondition;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.BaseDao;
import cn.warpin.core.base.dao.CommonRepository;
import cn.warpin.core.base.tableConf.bean.ColumnInfo;
import cn.warpin.core.base.tableConf.bean.TableConf;
import cn.warpin.core.base.tableConf.bean.TableInfo;
import cn.warpin.core.base.tableConf.dao.TableConfRepository;
import cn.warpin.core.database.redis.RedisOperate;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.JsonUtil;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class TableConfService {
    @Resource
    private TableConfDao tableConfDao;
    @Resource
    private TableConfRepository tableConfRepository;
    @Resource
    private CommonRepository commonRepository;
    @Resource
    private BaseDao baseDao;

    public Result create(EditReq in) {
        List entities = in.getEntities();
        for (Map tableConfVO : entities) {
            TableConf tableConf = new TableConf();
            ObjectUtil.copyMapPropertiesToClass((Map)tableConfVO, (Object)tableConf);
            this.tableConfDao.save(tableConf);
        }
        List newAllTableConfs = this.tableConfDao.findAll();
        this.resetRedisData(newAllTableConfs);
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        for (Map tableConfVO : entities) {
            TableConf tableConf = new TableConf();
            ObjectUtil.copyMapPropertiesToClass((Map)tableConfVO, (Object)tableConf);
            this.baseDao.update("TableConf", (Object)tableConf, "id");
        }
        List newAllTableConfs = this.tableConfDao.findAll();
        this.resetRedisData(newAllTableConfs);
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map tableConfVO : entities) {
            TableConf tableConf = new TableConf();
            ObjectUtil.copyMapPropertiesToClass((Map)tableConfVO, (Object)tableConf);
            this.tableConfDao.delete(tableConf);
        }
        List newAllTableConfs = this.tableConfDao.findAll();
        this.resetRedisData(newAllTableConfs);
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        TableConfCondition tableConfCondition = new TableConfCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)tableConfCondition));
        String pkg = tableConfCondition.getPkg();
        if (StrUtil.isEmpty((String)pkg)) {
            return Result.fail((ResCode)ResCode.NOT_EXIST);
        }
        List tableConfs = this.commonRepository.queryTableConf(pkg);
        BaseCondition baseCondition = condition.getBaseCondition();
        this.sort(tableConfs, baseCondition.getOderByFieldName(), baseCondition.getOderByOption());
        return Result.success((Object)tableConfs);
    }

    public Result initTableConf() {
        List currAllTableConfs = this.tableConfDao.findAll();
        System.out.println(currAllTableConfs);
        List<ColumnInfo> dbColumns = this.tableConfRepository.queryAllTableColumn();
        List dbTables = this.tableConfRepository.queryAllTableInfo();
        System.out.println(dbTables);
        dbColumns = this.setTableCommentToColumn(dbTables, dbColumns);
        System.out.println(dbColumns);
        Integer plusCount = this.addTableConfs(dbColumns, currAllTableConfs);
        Integer minusCount = this.deleteTableConfs(dbColumns, currAllTableConfs);
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        resultMap.put("plusCount", plusCount);
        resultMap.put("minusCount", minusCount);
        String resMsg = "\u672c\u6b21\u64cd\u4f5c\uff0c\u65b0\u589e\u4e86 " + plusCount + " \u6761\u8bb0\u5f55; \u5220\u9664\u4e86 " + minusCount + " \u6761\u8bb0\u5f55";
        List newAllTableConfs = this.tableConfDao.findAll();
        this.resetRedisData(newAllTableConfs);
        return Result.success(resultMap, (ResCode)ResCode.SUCCESS, (String)resMsg);
    }

    private List<ColumnInfo> setTableCommentToColumn(List<TableInfo> dbTables, List<ColumnInfo> dbColumns) {
        ArrayList<ColumnInfo> results = new ArrayList<ColumnInfo>();
        for (TableInfo tableInfo : dbTables) {
            String tableName = tableInfo.getTABLE_NAME();
            String tableLabel = tableInfo.getTABLE_COMMENT();
            List matchedColumns = dbColumns.stream().filter(o -> o.getTABLE_NAME().equals(tableName)).collect(Collectors.toList());
            if (!ArrayUtil.isNotEmpty(matchedColumns)) continue;
            for (ColumnInfo columnInfo : matchedColumns) {
                columnInfo.setTABLE_COMMENT(tableLabel);
                results.add(columnInfo);
            }
        }
        return results;
    }

    private Integer addTableConfs(List<ColumnInfo> dbColumns, List<TableConf> tableExists) {
        Integer plusCount = 0;
        for (ColumnInfo columnInfo : dbColumns) {
            List confs = tableExists.stream().filter(o -> o.getTableName().equals(columnInfo.getTABLE_NAME()) && o.getColumnName().equals(columnInfo.getCOLUMN_NAME())).collect(Collectors.toList());
            if (ArrayUtil.isNotEmpty(confs)) continue;
            TableConf tableConf = this.constructTableConfObject(columnInfo);
            this.tableConfDao.save(tableConf);
            Integer n = plusCount;
            plusCount = plusCount + 1;
        }
        return plusCount;
    }

    private Integer deleteTableConfs(List<ColumnInfo> dbColumns, List<TableConf> tableExists) {
        Integer minusCount = 0;
        for (TableConf tableConf : tableExists) {
            List columnInfos = dbColumns.stream().filter(o -> o.getTABLE_NAME().equals(tableConf.getTableName()) && o.getCOLUMN_NAME().equals(tableConf.getColumnName())).collect(Collectors.toList());
            if (ArrayUtil.isNotEmpty(columnInfos)) continue;
            this.tableConfDao.delete(tableConf);
            Integer n = minusCount;
            minusCount = minusCount + 1;
        }
        return minusCount;
    }

    private TableConf constructTableConfObject(ColumnInfo columnInfo) {
        TableConf tableConf = new TableConf();
        tableConf.setColumnName(columnInfo.getCOLUMN_NAME());
        tableConf.setColumnLabel(columnInfo.getCOLUMN_COMMENT());
        tableConf.setColumnOrmName(StrUtil.transformName((String)columnInfo.getCOLUMN_NAME(), (boolean)false));
        tableConf.setComponentType("INPUT");
        tableConf.setEditPosition(Integer.valueOf(9999));
        tableConf.setEditRequired("0");
        tableConf.setSqlIgnore("0");
        tableConf.setSqlSpellMode("EQ");
        tableConf.setTableName(columnInfo.getTABLE_NAME());
        String tableLabel = columnInfo.getTABLE_COMMENT();
        tableConf.setTableLabel(tableLabel);
        tableConf.setTablePosition(Integer.valueOf(9999));
        if ("unique_tag".equals(columnInfo.getCOLUMN_NAME())) {
            tableConf.setTableShow("0");
            tableConf.setEditShow("0");
            tableConf.setEditAble("0");
        } else {
            tableConf.setTableShow("1");
            tableConf.setEditShow("1");
            tableConf.setEditAble("1");
        }
        String tableName = columnInfo.getTABLE_NAME();
        String cleanTableName = tableName.substring(tableName.indexOf("_") + 1);
        tableConf.setEntityName(StrUtil.transformName((String)cleanTableName, (boolean)true));
        tableConf.setConditionType("0");
        tableConf.setPkg(columnInfo.getTABLE_NAME());
        return tableConf;
    }

    private void resetRedisData(List<TableConf> newAllTableConfs) {
        List noDuplicateTables = ArrayUtil.removeDuplicatesByKey(newAllTableConfs, TableConf::getTableName);
        HashMap<String, String> redisMap = new HashMap<String, String>();
        for (TableConf conf : noDuplicateTables) {
            List tableConfs = newAllTableConfs.stream().filter(o -> o.getTableName().equals(conf.getTableName())).collect(Collectors.toList());
            String json = JsonUtil.toJson(tableConfs);
            redisMap.put(conf.getPkg(), json);
        }
        RedisOperate.setMapValue((String)"table_conf", redisMap, (long)0L);
    }

    public Result queryGroupByPkg() {
        List<TableConf> confs = this.tableConfDao.queryGroupByPkg();
        return Result.success(confs);
    }

    private void sort(List<TableConf> tableConfs, String oderByFieldName, String oderByOption) {
        if (StrUtil.isNotEmpty((String)oderByFieldName)) {
            switch (oderByFieldName) {
                case "tablePosition": {
                    if ("ASC".equals(oderByOption)) {
                        tableConfs.sort(Comparator.comparing(TableConf::getTablePosition));
                    } else {
                        tableConfs.sort(Comparator.comparing(TableConf::getTablePosition).reversed());
                    }
                }
                case "editPosition": {
                    if ("ASC".equals(oderByOption)) {
                        tableConfs.sort(Comparator.comparing(TableConf::getEditPosition));
                        break;
                    }
                    tableConfs.sort(Comparator.comparing(TableConf::getEditPosition).reversed());
                }
            }
        }
    }
}

