/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.scoreManager.service;

import cn.warpin.business.syscenter.scoreManager.bean.ScoreManager;
import cn.warpin.business.syscenter.scoreManager.bean.ScoreManagerVO;
import cn.warpin.business.syscenter.scoreManager.dao.ScoreManagerDao;
import cn.warpin.business.syscenter.scoreManager.params.ScoreManagerCondition;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ObjectUtil;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ScoreManagerService {
    @Resource
    private ScoreManagerDao scoreManagerDao;
    @Resource
    private CommonService commonService;

    public Result save(EditReq in) {
        List entities = in.getEntities();
        Map sm = (Map)entities.get(0);
        String bizModule = (String)sm.get("bizModule");
        Double currRate = this.scoreManagerDao.sumTotalRate(bizModule);
        for (Map scoreManagerVO : entities) {
            ScoreManager scoreManager = new ScoreManager();
            ObjectUtil.copyMapPropertiesToClass((Map)scoreManagerVO, (Object)((Object)scoreManager));
            if (currRate != null && currRate + scoreManager.getTotalRate() > 100.0) {
                throw new ResultException(ResCode.OUT_OF_RANGE, "\u6dfb\u52a0\u7684\u5206\u6570\u6bd4\u7387\u5df2\u7ecf\u8d85\u8fc7100%");
            }
            this.scoreManagerDao.save((Object)scoreManager);
        }
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        Map sm = (Map)entities.get(0);
        String bizModule = (String)sm.get("bizModule");
        Double currRate = this.scoreManagerDao.sumTotalRate(bizModule);
        for (Map scoreManagerVO : entities) {
            ScoreManager scoreManager = new ScoreManager();
            ObjectUtil.copyMapPropertiesToClass((Map)scoreManagerVO, (Object)((Object)scoreManager));
            if (currRate + scoreManager.getTotalRate() > 100.0) {
                throw new ResultException(ResCode.OUT_OF_RANGE, "\u6dfb\u52a0\u7684\u5206\u6570\u6bd4\u7387\u5df2\u7ecf\u8d85\u8fc7100%");
            }
            this.scoreManagerDao.save((Object)scoreManager);
        }
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map scoreManagerVO : entities) {
            ScoreManager scoreManager = new ScoreManager();
            ObjectUtil.copyMapPropertiesToClass((Map)scoreManagerVO, (Object)((Object)scoreManager));
            this.scoreManagerDao.delete((Object)scoreManager);
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        ScoreManagerCondition scoreManagerCondition = new ScoreManagerCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)scoreManagerCondition));
        condition.setEntity((Object)scoreManagerCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)scoreManagerCondition));
        return this.commonService.queryVO(condition, ScoreManagerVO.class, voClassMap);
    }
}

