/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.role.service;

import cn.warpin.business.syscenter.role.bean.Role;
import cn.warpin.business.syscenter.role.bean.RoleVO;
import cn.warpin.business.syscenter.role.dao.RoleDao;
import cn.warpin.business.syscenter.role.params.PermissionData;
import cn.warpin.business.syscenter.role.params.RoleCondition;
import cn.warpin.business.syscenter.rolesBtn.bean.RolesBtn;
import cn.warpin.business.syscenter.rolesBtn.dao.RolesBtnDao;
import cn.warpin.business.syscenter.rolesMenu.bean.RolesMenu;
import cn.warpin.business.syscenter.rolesMenu.dao.RolesMenuDao;
import cn.warpin.business.syscenter.rolesModule.bean.RolesModule;
import cn.warpin.business.syscenter.rolesModule.dao.RolesModuleDao;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.BaseDao;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class RoleService {
    @Resource
    private RoleDao roleDao;
    @Resource
    private RolesMenuDao rolesMenuDao;
    @Resource
    private RolesModuleDao rolesModuleDao;
    @Resource
    private RolesBtnDao rolesBtnDao;
    @Resource
    private BaseDao baseDao;
    @Resource
    private CommonService commonService;

    public Result save(EditReq in) {
        List entities = in.getEntities();
        for (Map roleVO : entities) {
            Role role = new Role();
            ObjectUtil.copyMapPropertiesToClass((Map)roleVO, (Object)((Object)role));
            if (role.getId() == null) {
                role.setCode(StrUtil.randomKey((int)10));
            }
            this.roleDao.save((Object)role);
        }
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        for (Map roleVO : entities) {
            Role role = new Role();
            ObjectUtil.copyMapPropertiesToClass((Map)roleVO, (Object)((Object)role));
            this.baseDao.update("Role", (Object)role, "id");
        }
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map roleVO : entities) {
            Role role = new Role();
            ObjectUtil.copyMapPropertiesToClass((Map)roleVO, (Object)((Object)role));
            this.roleDao.delete((Object)role);
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        RoleCondition roleCondition = new RoleCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)roleCondition));
        condition.setEntity((Object)roleCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)roleCondition));
        return this.commonService.queryVO(condition, RoleVO.class, voClassMap);
    }

    public Result setRolesMenu(EditReq in) {
        List entities = in.getEntities();
        for (Map rolesMenuVO : entities) {
            RolesMenu rolesMenu = new RolesMenu();
            ObjectUtil.copyMapPropertiesToClass((Map)rolesMenuVO, (Object)((Object)rolesMenu));
            this.rolesMenuDao.save((Object)rolesMenu);
        }
        return Result.success();
    }

    public Result getRolesMenu(String roleCode) {
        List<RolesMenu> rolesMenus = this.rolesMenuDao.findByRoleCode(roleCode);
        return Result.success(rolesMenus);
    }

    public Result setRolesModule(EditReq in) {
        List entities = in.getEntities();
        for (Map rolesModuleVO : entities) {
            RolesModule rolesModule = new RolesModule();
            ObjectUtil.copyMapPropertiesToClass((Map)rolesModuleVO, (Object)((Object)rolesModule));
            this.rolesModuleDao.save((Object)rolesModule);
        }
        return Result.success();
    }

    public Result getRolesModule(String roleCode) {
        List<RolesModule> rolesModules = this.rolesModuleDao.findByRoleCode(roleCode);
        return Result.success(rolesModules);
    }

    public Result getPermissions(String roleCode) {
        final List<RolesModule> rolesModules = this.rolesModuleDao.findByRoleCode(roleCode);
        final List<RolesMenu> rolesMenus = this.rolesMenuDao.findByRoleCode(roleCode);
        final List<RolesBtn> rolesBtns = this.rolesBtnDao.findByRoleCode(roleCode);
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("rolesModule", rolesModules);
                this.put("rolesMenu", rolesMenus);
                this.put("rolesBtn", rolesBtns);
            }
        };
        return Result.success((Object)map);
    }

    public Result setPermissions(PermissionData permissionData) {
        List<RolesModule> rolesModules = permissionData.getRolesModule();
        List<RolesMenu> rolesMenus = permissionData.getRolesMenu();
        List<RolesBtn> rolesBtns = permissionData.getRolesBtn();
        if (ArrayUtil.isNotEmpty(rolesModules)) {
            this.rolesModuleDao.saveAll(rolesModules);
        }
        if (ArrayUtil.isNotEmpty(rolesMenus)) {
            this.rolesMenuDao.saveAll(rolesMenus);
        }
        if (ArrayUtil.isNotEmpty(rolesBtns)) {
            this.rolesBtnDao.saveAll(rolesBtns);
        }
        return Result.success();
    }
}

