/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.operationLog.service;

import cn.warpin.business.syscenter.operationLog.bean.OperationLog;
import cn.warpin.business.syscenter.operationLog.params.OperationLogCondition;
import cn.warpin.core.database.elastic.ElasticOperate;
import cn.warpin.core.database.elastic.params.ElasticCondition;
import cn.warpin.core.database.elastic.params.ElasticParams;
import cn.warpin.core.database.elastic.result.SearchResult;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import jakarta.annotation.Resource;
import java.sql.Timestamp;
import org.springframework.stereotype.Service;

@Service
public class OperationLogService {
    private final String index = "operation_log";
    @Resource
    private ElasticOperate elasticOperate;

    public Result create(OperationLog log) {
        log.setCreateTime(new Timestamp(System.currentTimeMillis()));
        ElasticParams params = new ElasticParams("operation_log", (Object)log);
        IndexResponse response = this.elasticOperate.createOrUpdateDocument(params);
        return Result.success((Object)response);
    }

    public Result deleteById(OperationLog log) {
        return Result.success((Object)this.elasticOperate.deleteDocument("operation_log", log.getId()));
    }

    public Result deleteAllDocuments() {
        return Result.success((Object)this.elasticOperate.deleteAllDocumentsInIndex("operation_log"));
    }

    public Result deleteIndex() {
        boolean response = this.elasticOperate.deleteIndex("operation_log");
        if (response) {
            return Result.success();
        }
        return Result.fail((ResCode)ResCode.ELASTIC_INDEX_NOT_EXIST);
    }

    public Result query(OperationLogCondition condition) {
        ElasticCondition logCondition = new ElasticCondition("operation_log", OperationLog.class);
        logCondition.setIndex("operation_log");
        if (condition.getFrom() != null && condition.getSize() != null) {
            logCondition.setFrom(condition.getFrom());
            logCondition.setSize(condition.getSize());
        }
        SearchResult searchResult = this.elasticOperate.searchDocuments(logCondition);
        return Result.success((Object)searchResult.getResults(), (Long)searchResult.getTotal());
    }
}

