/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.menu.service;

import cn.warpin.business.auth.cas.bean.CasRegisteredInfo;
import cn.warpin.business.auth.cas.bean.TicketParam;
import cn.warpin.business.auth.cas.service.CasService;
import cn.warpin.business.syscenter.menu.bean.Menu;
import cn.warpin.business.syscenter.menu.bean.MenuVO;
import cn.warpin.business.syscenter.menu.dao.MenuDao;
import cn.warpin.business.syscenter.menu.params.MenuCondition;
import cn.warpin.core.base.condition.BaseCondition;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.BaseDao;
import cn.warpin.core.base.jpa.tools.IdGenerator;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MenuService {
    @Resource
    private MenuDao menuDao;
    @Resource
    private BaseDao baseDao;
    @Resource
    private CasService casService;
    @Resource
    private CommonService commonService;
    private Integer level;

    public Result save(EditReq in) {
        try {
            List entities = in.getEntities();
            for (Map menuVOMap : entities) {
                MenuVO menuVO = new MenuVO();
                ObjectUtil.copyMapPropertiesToClass((Map)menuVOMap, (Object)((Object)menuVO));
                if (menuVO.getId() == null) {
                    menuVO.setCode(StrUtil.randomKey((int)10));
                }
                Menu menu = new Menu();
                BeanUtils.copyProperties((Object)((Object)menuVO), (Object)((Object)menu));
                this.syncCasRegistryService(menuVO);
                menu.setCasRegistryServiceId(menuVO.getCasRegistryServiceId());
                this.menuDao.save((Object)menu);
            }
        }
        catch (Exception e) {
            throw new ResultException(ResCode.REGISTRY_SERVICE_FAIL);
        }
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        for (Map menuVOMap : entities) {
            MenuVO menuVO = new MenuVO();
            ObjectUtil.copyMapPropertiesToClass((Map)menuVOMap, (Object)((Object)menuVO));
            this.syncCasRegistryService(menuVO);
            Menu menu = new Menu();
            BeanUtils.copyProperties((Object)((Object)menuVO), (Object)((Object)menu));
            this.baseDao.update("Menu", (Object)menu, "id");
        }
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map menuVO : entities) {
            Menu menu = new Menu();
            ObjectUtil.copyMapPropertiesToClass((Map)menuVO, (Object)((Object)menu));
            this.menuDao.delete((Object)menu);
            this.casService.deleteOriginData(menu.getCasRegistryServiceId());
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        MenuCondition menuCondition = new MenuCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)menuCondition));
        condition.setEntity((Object)menuCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)menuCondition));
        Result result = this.commonService.queryVO(condition, MenuVO.class, voClassMap);
        return result;
    }

    public Result queryMenuTree() {
        QueryCondition queryCondition = new QueryCondition(new BaseCondition(), (Object)new MenuCondition());
        List list = (List)this.query(queryCondition).getRoot();
        List<MenuVO> resultList = this.fmtMenu("0", list);
        return Result.success(resultList);
    }

    private List<MenuVO> fmtMenu(String code, List<MenuVO> menuList) {
        ArrayList<MenuVO> list = new ArrayList<MenuVO>();
        for (MenuVO menu : menuList) {
            Integer n;
            boolean isChildExist;
            if (!menu.getParentCode().equals(code)) continue;
            if ("0".equals(code)) {
                this.level = 0;
            }
            if (isChildExist = menuList.stream().anyMatch(c -> c.getParentCode().equals(menu.getCode()))) {
                n = this.level;
                this.level = this.level + 1;
                List<MenuVO> children = this.fmtMenu(menu.getCode(), menuList);
                menu.setChildren(children);
                menu.setLastLevel("0");
            } else {
                n = this.level;
                this.level = this.level + 1;
                menu.setLastLevel("1");
            }
            n = this.level;
            this.level = this.level - 1;
            list.add(menu);
        }
        return list;
    }

    private void syncCasRegistryService(MenuVO menu) {
        if (StrUtil.isNotEmpty((String)menu.getServiceUrl())) {
            Integer registryId = menu.getCasRegistryServiceId() != null && menu.getCasRegistryServiceId() > 0 ? menu.getCasRegistryServiceId() : IdGenerator.getNextId();
            menu.setCasRegistryServiceId(registryId);
            TicketParam ticketParam = new TicketParam();
            ticketParam.setService(menu.getServiceUrl());
            ticketParam.setMenuLabel(menu.getName());
            ticketParam.setUserId(menu.getUserId());
            ticketParam.setLoginType(menu.getLoginType());
            ticketParam.setCasRegisteredInfo(new CasRegisteredInfo(registryId));
            this.casService.servicesRegistry(ticketParam);
        }
    }
}

