/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.language.langContentKey.service;

import cn.warpin.business.syscenter.language.langContent.bean.LangContentVO;
import cn.warpin.business.syscenter.language.langContent.params.LangContentCondition;
import cn.warpin.business.syscenter.language.langContent.service.LangContentService;
import cn.warpin.business.syscenter.language.langContentKey.bean.LangContentKey;
import cn.warpin.business.syscenter.language.langContentKey.bean.LangContentKeyVO;
import cn.warpin.business.syscenter.language.langContentKey.dao.LangContentKeyDao;
import cn.warpin.business.syscenter.language.langContentKey.params.LangContentKeyCondition;
import cn.warpin.core.base.condition.BaseCondition;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.BaseDao;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.ObjectUtil;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class LangContentKeyService {
    @Resource
    private LangContentKeyDao langContentKeyDao;
    @Resource
    private LangContentService langContentService;
    @Resource
    private BaseDao baseDao;
    @Resource
    private CommonService commonService;

    public Result save(EditReq in) {
        List entities = in.getEntities();
        for (Map langContentKeyVO : entities) {
            LangContentKey langContentKey = new LangContentKey();
            ObjectUtil.copyMapPropertiesToClass((Map)langContentKeyVO, (Object)((Object)langContentKey));
            this.langContentKeyDao.save((Object)langContentKey);
        }
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        for (Map langContentKeyVO : entities) {
            LangContentKey langContentKey = new LangContentKey();
            ObjectUtil.copyMapPropertiesToClass((Map)langContentKeyVO, (Object)((Object)langContentKey));
            this.baseDao.update("LangContentKey", (Object)langContentKey, "id");
        }
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map langContentKeyVO : entities) {
            LangContentKey langContentKey = new LangContentKey();
            ObjectUtil.copyMapPropertiesToClass((Map)langContentKeyVO, (Object)((Object)langContentKey));
            this.langContentKeyDao.delete((Object)langContentKey);
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        LangContentKeyCondition langContentKeyCondition = new LangContentKeyCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)langContentKeyCondition));
        condition.setEntity((Object)langContentKeyCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)langContentKeyCondition));
        Result result = this.commonService.queryVO(condition, LangContentKeyVO.class, voClassMap);
        return result;
    }

    public Result queryLangContentKey(QueryCondition condition) {
        Result result = this.query(condition);
        List langContentKeyVOS = (List)result.getRoot();
        ArrayList<String> keyNames = new ArrayList<String>();
        if (ArrayUtil.isEmpty((List)langContentKeyVOS)) {
            return result;
        }
        for (LangContentKeyVO contentKey : langContentKeyVOS) {
            keyNames.add(contentKey.getKeyName());
        }
        BaseCondition baseCondition = new BaseCondition();
        LangContentCondition langContentCondition = new LangContentCondition();
        langContentCondition.setPkg_language_father("sys_language");
        String ckNames = keyNames.stream().map(Object::toString).collect(Collectors.joining(","));
        langContentCondition.setCkName(ckNames);
        Map langContentConditionMap = ObjectUtil.transBean2Map((Object)((Object)langContentCondition));
        QueryCondition queryCondition = new QueryCondition(baseCondition, (Object)langContentConditionMap);
        Result queryResult = this.langContentService.query(queryCondition);
        List contents = null;
        if (queryResult.getRoot() != null && !((List)queryResult.getRoot()).isEmpty()) {
            contents = (List)queryResult.getRoot();
            for (LangContentKeyVO contentKey : langContentKeyVOS) {
                List<LangContentVO> selectContents = contents.stream().filter(o -> o.getCkName().equals(contentKey.getKeyName())).collect(Collectors.toList());
                contentKey.setLangContent(selectContents);
            }
        }
        return result;
    }
}

