/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.employee.service;

import cn.warpin.business.auth.cas.bean.Credential;
import cn.warpin.business.auth.cas.service.CasService;
import cn.warpin.business.syscenter.bizModule.dao.BizModuleDao;
import cn.warpin.business.syscenter.employee.bean.Admin;
import cn.warpin.business.syscenter.employee.bean.Employee;
import cn.warpin.business.syscenter.employee.bean.EmployeeVO;
import cn.warpin.business.syscenter.employee.dao.AdminDao;
import cn.warpin.business.syscenter.employee.dao.EmployeeDao;
import cn.warpin.business.syscenter.employee.params.EmpLoginData;
import cn.warpin.business.syscenter.employee.params.EmployeeCondition;
import cn.warpin.business.syscenter.employee.params.UpdatePwdParam;
import cn.warpin.business.syscenter.employee.service.Permission;
import cn.warpin.business.syscenter.menu.bean.Menu;
import cn.warpin.business.syscenter.menu.dao.MenuDao;
import cn.warpin.business.syscenter.rolesBtn.bean.RolesBtn;
import cn.warpin.business.syscenter.rolesBtn.dao.RolesBtnDao;
import cn.warpin.business.syscenter.rolesMenu.bean.RolesMenu;
import cn.warpin.business.syscenter.rolesMenu.dao.RolesMenuDao;
import cn.warpin.business.syscenter.rolesModule.bean.RolesModule;
import cn.warpin.business.syscenter.rolesModule.dao.RolesModuleDao;
import cn.warpin.core.base.condition.BaseCondition;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.BaseDao;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.constant.EnumStore;
import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import cn.warpin.core.security.jwt.JwtUtils;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.CheckUtil;
import cn.warpin.core.util.EncryptUtil;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class EmployeeService {
    @Resource
    private BaseDao baseDao;
    @Resource
    private EmployeeDao employeeDao;
    @Resource
    private AdminDao adminDao;
    @Resource
    private RolesMenuDao rolesMenuDao;
    @Resource
    private RolesModuleDao rolesModuleDao;
    @Resource
    private RolesBtnDao rolesBtnDao;
    @Resource
    private MenuDao menuDao;
    @Resource
    private BizModuleDao bizModuleDao;
    @Resource
    private CommonService commonService;
    @Resource
    private CasService casService;
    @Resource
    private PasswordEncoder passwordEncoder;

    public Result save(EditReq in) {
        block7: {
            try {
                List entities = in.getEntities();
                for (Map employeeVO : entities) {
                    Employee employee = new Employee();
                    ObjectUtil.copyMapPropertiesToClass((Map)employeeVO, (Object)((Object)employee));
                    if (employee.getId() == null) {
                        this.createEmpLogic(employee);
                    }
                    this.employeeDao.save((Object)employee);
                }
            }
            catch (Exception e) {
                String key = StrUtil.extractKeyFromErrorMessage((String)e.getMessage());
                if ("account".equals(key)) {
                    throw new ResultException(ResCode.DB_ERROR, "\u8d26\u6237\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
                }
                if ("tel".equals(key)) {
                    throw new ResultException(ResCode.DB_ERROR, "\u7535\u8bdd\u53f7\u7801\u5df2\u7ecf\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
                }
                if ("email".equals(key)) {
                    throw new ResultException(ResCode.DB_ERROR, "\u90ae\u7bb1\u5df2\u7ecf\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
                }
                if (!"idNumber".equals(key)) break block7;
                throw new ResultException(ResCode.DB_ERROR, "\u8bc1\u4ef6\u53f7\u7801\u5df2\u7ecf\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
            }
        }
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        for (Map employeeVO : entities) {
            Employee employee = new Employee();
            ObjectUtil.copyMapPropertiesToClass((Map)employeeVO, (Object)((Object)employee));
            this.baseDao.update("Employee", (Object)employee, "id");
        }
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map employeeVO : entities) {
            Employee employee = new Employee();
            ObjectUtil.copyMapPropertiesToClass((Map)employeeVO, (Object)((Object)employee));
            this.employeeDao.delete((Object)employee);
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        EmployeeCondition employeeCondition = new EmployeeCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)employeeCondition));
        condition.setEntity((Object)employeeCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)employeeCondition));
        return this.commonService.queryVO(condition, EmployeeVO.class, voClassMap);
    }

    public Result login(EmpLoginData empLoginData) {
        Result adminLoginResult = this.adminLogin(empLoginData.getAccount(), empLoginData.getPassword());
        Integer resCode = adminLoginResult.getCode();
        if (resCode.equals(ResCode.INCORRECT_PWD.getKey())) {
            return adminLoginResult;
        }
        if (resCode.equals(ResCode.SUCCESS.getKey())) {
            EmployeeVO employee = new EmployeeVO();
            employee.setToken((String)adminLoginResult.getRoot());
            employee.setAccount(empLoginData.getAccount());
            employee.setRole("0");
            return Result.success((Object)((Object)employee));
        }
        EmployeeCondition employeeCondition = this.getLoginCondition(empLoginData.getAccount());
        QueryCondition condition = new QueryCondition(new BaseCondition(), (Object)employeeCondition);
        Result empQueryResult = this.query(condition);
        List employeeVOS = (List)empQueryResult.getRoot();
        EmployeeVO employeeVO = null;
        if (ArrayUtil.isNotEmpty((List)employeeVOS)) {
            employeeVO = (EmployeeVO)((Object)employeeVOS.get(0));
            String currPwd = EncryptUtil.encode((String)empLoginData.getPassword());
            if (!currPwd.equals(employeeVO.getEncryptPassword())) {
                return Result.fail((ResCode)ResCode.INCORRECT_PWD);
            }
        } else {
            return Result.fail((ResCode)ResCode.INCORRECT_PWD, (String)"\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        String token = JwtUtils.createToken((String)EnumStore.LOGIN_TYPE_EMP.getKey(), (String)employeeVO.getAccount(), (String)employeeVO.getId().toString());
        employeeVO.setToken(token);
        employeeVO.setRole("1");
        Permission permission = this.getPermissions(employeeVO);
        employeeVO.setPermission(permission);
        return Result.success((Object)((Object)employeeVO));
    }

    public Result loginWithCas(EmpLoginData empLoginData) {
        Credential credential;
        Result tgtResult;
        Result result = this.login(empLoginData);
        EmployeeVO employee = null;
        if (result.getCode().equals(ResCode.SUCCESS.getKey()) && (tgtResult = this.casService.getTGT(credential = new Credential((employee = (EmployeeVO)((Object)result.getRoot())).getAccount(), empLoginData.getPassword()))).getCode().equals(ResCode.SUCCESS.getKey())) {
            employee.setTgt(tgtResult.getRoot().toString());
            result.setRoot((Object)employee);
        }
        return result;
    }

    private Result adminLogin(String account, String password) {
        if (!account.equalsIgnoreCase(EnumStore.ADMIN_ACCOUNT_1.getKey()) && !account.equalsIgnoreCase(EnumStore.ADMIN_ACCOUNT_2.getKey())) {
            return Result.fail((ResCode)ResCode.INCORRECT_ACCOUNT);
        }
        Optional optional = this.adminDao.findById(1);
        if (optional.isEmpty()) {
            return Result.fail((ResCode)ResCode.SYS_EMP_NOT_EXIST, (String)"\u7ba1\u7406\u5458\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        Admin admin = (Admin)optional.get();
        if (!password.equals(admin.getPassword())) {
            return Result.fail((ResCode)ResCode.INCORRECT_PWD);
        }
        String token = JwtUtils.createToken((String)EnumStore.LOGIN_TYPE_ADMIN.getKey(), (String)account, (String)"1");
        return Result.success((Object)token);
    }

    private EmployeeCondition getLoginCondition(String loginTitle) {
        EmployeeCondition condition = new EmployeeCondition();
        if (CheckUtil.isValidPhoneNumber((String)loginTitle)) {
            condition.setTel(loginTitle);
        } else if (CheckUtil.isValidEmail((String)loginTitle)) {
            condition.setEmail(loginTitle);
        } else if (CheckUtil.isValidIDCard((String)loginTitle)) {
            condition.setIdNumber(loginTitle);
        } else if (condition != null) {
            condition.setAccount(loginTitle);
        }
        return condition;
    }

    private void createEmpLogic(Employee employee) {
        String password;
        String uuid = StrUtil.uuid32();
        employee.setUuid(uuid);
        if (StrUtil.isEmpty((String)employee.getAccount())) {
            employee.setAccount(employee.getTel());
        }
        if (StrUtil.isEmpty((String)(password = employee.getPassword()))) {
            password = EnumStore.EMP_DEFAULT_PASSWORD.getKey();
        }
        employee.setPassword(password);
        employee.setSecurityPassword(this.passwordEncoder.encode((CharSequence)password));
        employee.setEncryptPassword(EncryptUtil.encode((String)password));
    }

    private Permission getPermissions(EmployeeVO employeeVO) {
        String roleCode = employeeVO.getRoleCode();
        Permission permission = new Permission();
        if (StrUtil.isNotEmpty((String)roleCode)) {
            List<RolesMenu> rolesMenus = this.rolesMenuDao.findByRoleCode(roleCode);
            ArrayList<String> menuCodes = new ArrayList<String>();
            for (RolesMenu rolesMenu : rolesMenus) {
                if (rolesMenu.getPermission().equals("0")) continue;
                menuCodes.add(rolesMenu.getMenuCode());
            }
            List<Menu> menuList = this.menuDao.findByCodeIn(menuCodes);
            ArrayList<String> menus = new ArrayList<String>();
            ArrayList<String> buttons = new ArrayList<String>();
            for (Menu menu : menuList) {
                if (menu.getMenuType().equals("1")) {
                    buttons.add(menu.getCode());
                    continue;
                }
                menus.add(menu.getCode());
            }
            List<RolesModule> rolesModules = this.rolesModuleDao.findByRoleCode(roleCode);
            ArrayList<String> moduleCodes = new ArrayList<String>();
            for (RolesModule rolesModule : rolesModules) {
                if (rolesModule.getPermission().equals("0")) continue;
                moduleCodes.add(rolesModule.getModuleCode());
            }
            List<RolesBtn> rolesBtns = this.rolesBtnDao.findByRoleCode(roleCode);
            ArrayList<String> clientBtnCodes = new ArrayList<String>();
            for (RolesBtn rolesBtn : rolesBtns) {
                if (rolesBtn.getPermission().equals("0")) continue;
                clientBtnCodes.add(rolesBtn.getBtnCode());
            }
            permission.setMenus(menus);
            permission.setButtons(buttons);
            permission.setModules(moduleCodes);
            permission.setSubSysBtns(clientBtnCodes);
        }
        return permission;
    }

    public Result modifyPassword(UpdatePwdParam updatePwdParam) {
        Optional optional = this.employeeDao.findById(updatePwdParam.getEmpId());
        if (optional.isEmpty()) {
            return Result.fail((ResCode)ResCode.NOT_EXIST, (String)"\u8be5\u5458\u5de5\u4e0d\u5b58\u5728");
        }
        Employee employee = (Employee)((Object)optional.get());
        String encryptOldPwd = EncryptUtil.encode((String)updatePwdParam.getOldPassword());
        if (!encryptOldPwd.equals(employee.getPassword())) {
            return Result.fail((ResCode)ResCode.INCORRECT_PWD);
        }
        String encryptNewPwd = EncryptUtil.encode((String)updatePwdParam.getNewPassword());
        employee.setEncryptPassword(encryptNewPwd);
        employee.setPassword(this.passwordEncoder.encode((CharSequence)updatePwdParam.getNewPassword()));
        this.employeeDao.save((Object)employee);
        return Result.success();
    }

    public Result resetPassword(UpdatePwdParam updatePwdParam) {
        Optional optional = this.employeeDao.findById(updatePwdParam.getEmpId());
        if (optional.isEmpty()) {
            return Result.fail((ResCode)ResCode.NOT_EXIST, (String)"\u8be5\u5458\u5de5\u4e0d\u5b58\u5728");
        }
        Employee employee = (Employee)((Object)optional.get());
        String encryptNewPwd = EncryptUtil.encode((String)EnumStore.EMP_DEFAULT_PASSWORD.getKey());
        employee.setPassword(encryptNewPwd);
        this.employeeDao.save((Object)employee);
        return Result.success();
    }
}

