/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.employee.controller;

import cn.warpin.business.syscenter.employee.params.EmpLoginData;
import cn.warpin.business.syscenter.employee.params.UpdatePwdParam;
import cn.warpin.business.syscenter.employee.service.EmployeeService;
import cn.warpin.core.base.BaseController;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.result.Result;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/syscenter/employee"})
public class EmployeeController
implements BaseController {
    @Resource
    private EmployeeService employeeService;

    @PostMapping(value={"create"})
    public Result create(@RequestBody EditReq in) {
        return this.employeeService.save(in);
    }

    @PutMapping(value={"update"})
    public Result update(@RequestBody EditReq in) {
        return this.employeeService.update(in);
    }

    @DeleteMapping(value={"delete"})
    public Result delete(@RequestBody EditReq in) {
        return this.employeeService.delete(in);
    }

    @PostMapping(value={"query"})
    public Result query(@RequestBody QueryCondition condition) {
        return this.employeeService.query(condition);
    }

    @PostMapping(value={"login"})
    public Result login(@RequestBody EmpLoginData empLoginData) {
        return this.employeeService.loginWithCas(empLoginData);
    }

    @PostMapping(value={"modifyPassword"})
    public Result modifyPassword(@RequestBody UpdatePwdParam param) {
        return this.employeeService.modifyPassword(param);
    }

    @PostMapping(value={"resetPassword"})
    public Result resetPassword(@RequestBody UpdatePwdParam param) {
        return this.employeeService.resetPassword(param);
    }
}

