/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.department.service;

import cn.warpin.business.syscenter.department.bean.Department;
import cn.warpin.business.syscenter.department.bean.DepartmentVO;
import cn.warpin.business.syscenter.department.dao.DepartmentDao;
import cn.warpin.business.syscenter.department.params.DepartmentCondition;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.BaseDao;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ObjectUtil;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class DepartmentService {
    @Resource
    private DepartmentDao departmentDao;
    @Resource
    private BaseDao baseDao;
    @Resource
    private CommonService commonService;

    public Result save(EditReq in) {
        List entities = in.getEntities();
        for (Map departmentVO : entities) {
            Department department = new Department();
            ObjectUtil.copyMapPropertiesToClass((Map)departmentVO, (Object)((Object)department));
            this.departmentDao.save((Object)department);
        }
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        for (Map departmentVO : entities) {
            Department department = new Department();
            ObjectUtil.copyMapPropertiesToClass((Map)departmentVO, (Object)((Object)department));
            this.baseDao.update("Department", (Object)department, "id");
        }
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map departmentVO : entities) {
            Department department = new Department();
            ObjectUtil.copyMapPropertiesToClass((Map)departmentVO, (Object)((Object)department));
            this.departmentDao.delete((Object)department);
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        DepartmentCondition departmentCondition = new DepartmentCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)departmentCondition));
        condition.setEntity((Object)departmentCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)departmentCondition));
        return this.commonService.queryVO(condition, DepartmentVO.class, voClassMap);
    }
}

