/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.componentOption.service;

import cn.warpin.business.syscenter.componentOption.bean.ComponentOption;
import cn.warpin.business.syscenter.componentOption.bean.ComponentOptionVO;
import cn.warpin.business.syscenter.componentOption.dao.ComponentOptionDao;
import cn.warpin.business.syscenter.componentOption.params.ComponentOptionCondition;
import cn.warpin.core.base.condition.BaseCondition;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ComponentOptionService {
    @Resource
    private ComponentOptionDao componentOptionDao;
    @Resource
    private CommonService commonService;

    public Result save(EditReq in) {
        List entities = in.getEntities();
        for (Map componentOptionVO : entities) {
            ComponentOption componentOption = new ComponentOption();
            componentOption.setOptionTag(StrUtil.randomKey((int)10));
            ObjectUtil.copyMapPropertiesToClass((Map)componentOptionVO, (Object)((Object)componentOption));
            this.componentOptionDao.save((Object)componentOption);
        }
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        for (Map componentOptionVO : entities) {
            ComponentOption componentOption = new ComponentOption();
            ObjectUtil.copyMapPropertiesToClass((Map)componentOptionVO, (Object)((Object)componentOption));
            this.componentOptionDao.save((Object)componentOption);
        }
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map componentOptionVO : entities) {
            ComponentOption componentOption = new ComponentOption();
            ObjectUtil.copyMapPropertiesToClass((Map)componentOptionVO, (Object)((Object)componentOption));
            this.componentOptionDao.delete((Object)componentOption);
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        ComponentOptionCondition componentOptionCondition = new ComponentOptionCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)componentOptionCondition));
        condition.setEntity((Object)componentOptionCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)componentOptionCondition));
        Result result = this.commonService.queryVO(condition, ComponentOptionVO.class, voClassMap);
        return result;
    }

    public List<ComponentOption> queryChildrenByParentTag(ComponentOptionCondition componentOptionCondition) {
        componentOptionCondition.setPkg_children("sys_component_option");
        QueryCondition queryCondition = new QueryCondition(new BaseCondition(), (Object)componentOptionCondition);
        List pComponentOptions = (List)this.query(queryCondition).getRoot();
        List<ComponentOption> children = new ArrayList<ComponentOption>();
        if (ArrayUtil.isNotEmpty((List)pComponentOptions)) {
            ComponentOptionVO parentComponentOption = (ComponentOptionVO)((Object)pComponentOptions.get(0));
            children = parentComponentOption.getChildren();
        }
        return children;
    }

    public List<ComponentOption> queryChildrenByParentTag(String tag) {
        ComponentOptionCondition componentOptionCondition = new ComponentOptionCondition();
        componentOptionCondition.setOptionTag(tag);
        componentOptionCondition.setPkg_children("sys_component_option");
        QueryCondition queryCondition = new QueryCondition(new BaseCondition(), (Object)componentOptionCondition);
        List pComponentOptions = (List)this.query(queryCondition).getRoot();
        List<ComponentOption> children = new ArrayList<ComponentOption>();
        if (ArrayUtil.isNotEmpty((List)pComponentOptions)) {
            ComponentOptionVO parentComponentOption = (ComponentOptionVO)((Object)pComponentOptions.get(0));
            children = parentComponentOption.getChildren();
        }
        return children;
    }

    public ComponentOption queryNodeByTag(String tag) {
        List<ComponentOption> options = this.componentOptionDao.findByOptionTag(tag);
        if (ArrayUtil.isEmpty(options)) {
            return null;
        }
        return options.get(0);
    }
}

