/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.commonSetting.service;

import cn.warpin.business.syscenter.commonSetting.bean.CommonSetting;
import cn.warpin.business.syscenter.commonSetting.bean.CommonSettingVO;
import cn.warpin.business.syscenter.commonSetting.dao.CommonSettingDao;
import cn.warpin.business.syscenter.commonSetting.params.CommonSettingCondition;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CommonSettingService {
    @Resource
    private CommonSettingDao commonSettingDao;
    @Resource
    private CommonService commonService;

    public Result save(EditReq in) {
        List entities = in.getEntities();
        for (Map commonSettingVO : entities) {
            CommonSetting commonSetting = new CommonSetting();
            commonSetting.setSettingTag(StrUtil.randomKey((int)10));
            ObjectUtil.copyMapPropertiesToClass((Map)commonSettingVO, (Object)((Object)commonSetting));
            this.commonSettingDao.save((Object)commonSetting);
        }
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        for (Map commonSettingVO : entities) {
            CommonSetting commonSetting = new CommonSetting();
            ObjectUtil.copyMapPropertiesToClass((Map)commonSettingVO, (Object)((Object)commonSetting));
            this.commonSettingDao.save((Object)commonSetting);
        }
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map commonSettingVO : entities) {
            CommonSetting commonSetting = new CommonSetting();
            ObjectUtil.copyMapPropertiesToClass((Map)commonSettingVO, (Object)((Object)commonSetting));
            this.commonSettingDao.delete((Object)commonSetting);
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        CommonSettingCondition commonSettingCondition = new CommonSettingCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)commonSettingCondition));
        condition.setEntity((Object)commonSettingCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)commonSettingCondition));
        Result result = this.commonService.queryVO(condition, CommonSettingVO.class, voClassMap);
        return result;
    }

    public CommonSetting queryBySingleTag(String tag) {
        CommonSetting result = null;
        List<CommonSetting> settings = this.commonSettingDao.findBySettingTag(tag);
        if (ArrayUtil.isNotEmpty(settings)) {
            result = settings.get(0);
        }
        return result;
    }
}

