/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.clientBtn.service;

import cn.warpin.business.syscenter.clientBtn.bean.ClientBtn;
import cn.warpin.business.syscenter.clientBtn.bean.ClientBtnVO;
import cn.warpin.business.syscenter.clientBtn.dao.ClientBtnDao;
import cn.warpin.business.syscenter.clientBtn.params.ClientBtnCondition;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.BaseDao;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ClientBtnService {
    @Resource
    private ClientBtnDao clientBtnDao;
    @Resource
    private BaseDao baseDao;
    @Resource
    private CommonService commonService;

    public Result save(ClientBtn clientBtn) {
        if (null == clientBtn.getId()) {
            String code = this.genBtnCode();
            clientBtn.setBtnCode(code);
        }
        this.clientBtnDao.save((Object)clientBtn);
        return Result.success();
    }

    private String genBtnCode() {
        String code = StrUtil.randomKey((int)18);
        boolean exist = this.clientBtnDao.existsByBtnCode(code);
        if (exist) {
            code = this.genBtnCode();
        }
        return code;
    }

    public Result update(ClientBtn clientBtn) {
        this.baseDao.update("ClientBtn", (Object)clientBtn, "id");
        return Result.success();
    }

    public Result delete(ClientBtn clientBtn) {
        this.clientBtnDao.delete((Object)clientBtn);
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        ClientBtnCondition clientBtnCondition = new ClientBtnCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)clientBtnCondition));
        condition.setEntity((Object)clientBtnCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)clientBtnCondition));
        return this.commonService.queryVO(condition, ClientBtnVO.class, voClassMap);
    }
}

