/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.categoryType.service;

import cn.warpin.business.syscenter.category.dao.CategoryDao;
import cn.warpin.business.syscenter.categoryType.bean.CategoryType;
import cn.warpin.business.syscenter.categoryType.bean.CategoryTypeVO;
import cn.warpin.business.syscenter.categoryType.dao.CategoryTypeDao;
import cn.warpin.business.syscenter.categoryType.params.CategoryTypeCondition;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CategoryTypeService {
    @Resource
    private CategoryTypeDao categoryTypeDao;
    @Resource
    private CategoryDao categoryDao;
    @Resource
    private CommonService commonService;

    public Result save(EditReq in) {
        List entities = in.getEntities();
        for (Map categoryTypeVO : entities) {
            CategoryType categoryType = new CategoryType();
            if (StrUtil.isEmpty((String)((String)categoryTypeVO.get("uniqueTag")))) {
                categoryType.setUniqueTag(StrUtil.uuid32());
            }
            ObjectUtil.copyMapPropertiesToClass((Map)categoryTypeVO, (Object)((Object)categoryType));
            this.categoryTypeDao.save((Object)categoryType);
        }
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        for (Map categoryTypeVO : entities) {
            CategoryType categoryType = new CategoryType();
            ObjectUtil.copyMapPropertiesToClass((Map)categoryTypeVO, (Object)((Object)categoryType));
            this.categoryTypeDao.save((Object)categoryType);
        }
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map categoryTypeVO : entities) {
            CategoryType categoryType = new CategoryType();
            ObjectUtil.copyMapPropertiesToClass((Map)categoryTypeVO, (Object)((Object)categoryType));
            this.categoryTypeDao.delete((Object)categoryType);
            this.categoryDao.deleteByCategoryTypeId(categoryType.getId());
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        CategoryTypeCondition categoryTypeCondition = new CategoryTypeCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)categoryTypeCondition));
        condition.setEntity((Object)categoryTypeCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)categoryTypeCondition));
        return this.commonService.queryVO(condition, CategoryTypeVO.class, voClassMap);
    }
}

