/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.category.service;

import cn.warpin.business.syscenter.category.bean.Category;
import cn.warpin.business.syscenter.category.bean.CategoryVO;
import cn.warpin.business.syscenter.category.dao.CategoryDao;
import cn.warpin.business.syscenter.category.params.CategoryCondition;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CategoryService {
    @Resource
    private CategoryDao categoryDao;
    @Resource
    private CommonService commonService;
    private Integer level;

    public Result save(EditReq in) {
        List entities = in.getEntities();
        for (Map categoryVO : entities) {
            Category category = new Category();
            category.setUniqueTag(StrUtil.uuid32());
            ObjectUtil.copyMapPropertiesToClass((Map)categoryVO, (Object)((Object)category));
            this.categoryDao.save((Object)category);
        }
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        for (Map categoryVO : entities) {
            Category category = new Category();
            ObjectUtil.copyMapPropertiesToClass((Map)categoryVO, (Object)((Object)category));
            this.categoryDao.save((Object)category);
        }
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map categoryVO : entities) {
            Integer id = (Integer)categoryVO.get("id");
            this.recursionDelete(id);
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        CategoryCondition categoryCondition = new CategoryCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)categoryCondition));
        condition.setEntity((Object)categoryCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)categoryCondition));
        return this.commonService.queryVO(condition, CategoryVO.class, voClassMap);
    }

    public Result queryCategoryTree(QueryCondition condition) {
        List list = (List)this.query(condition).getRoot();
        List<CategoryVO> resultList = this.fmtCategory(0, list);
        return Result.success(resultList);
    }

    private List<CategoryVO> fmtCategory(Integer parentId, List<CategoryVO> cateList) {
        ArrayList<CategoryVO> list = new ArrayList<CategoryVO>();
        for (CategoryVO cate : cateList) {
            Integer n;
            boolean isChildExist;
            if (!cate.getParentId().equals(parentId)) continue;
            if (parentId.equals(0)) {
                this.level = 0;
            }
            if (isChildExist = cateList.stream().anyMatch(c -> c.getParentId().equals(cate.getId()))) {
                n = this.level;
                this.level = this.level + 1;
                List<CategoryVO> children = this.fmtCategory(cate.getId(), cateList);
                cate.setChildren(children);
                cate.setLastLevel("0");
            } else {
                n = this.level;
                this.level = this.level + 1;
                cate.setLastLevel(this.level >= 3 ? "1" : "0");
            }
            n = this.level;
            this.level = this.level - 1;
            list.add(cate);
        }
        return list;
    }

    private void recursionDelete(Integer id) {
        List<Category> children = this.categoryDao.findByParentId(id);
        if (ArrayUtil.isNotEmpty(children)) {
            for (Category category : children) {
                this.recursionDelete(category.getId());
            }
        }
        this.categoryDao.deleteById(id);
    }

    private List<CategoryVO> sortCategory(List<CategoryVO> cateList) {
        Collections.sort(cateList, new Comparator<CategoryVO>(this){

            @Override
            public int compare(CategoryVO arg0, CategoryVO arg1) {
                return arg0.getPosition().compareTo(arg1.getPosition());
            }
        });
        for (CategoryVO cate : cateList) {
            if (!ArrayUtil.isNotEmpty(cate.getChildren())) continue;
            List<CategoryVO> children = cate.getChildren();
            children = this.sortCategory(children);
        }
        return cateList;
    }
}

