/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.syscenter.bizModule.service;

import cn.warpin.business.syscenter.bizModule.bean.BizModule;
import cn.warpin.business.syscenter.bizModule.bean.BizModuleVO;
import cn.warpin.business.syscenter.bizModule.dao.BizModuleDao;
import cn.warpin.business.syscenter.bizModule.params.BizModuleCondition;
import cn.warpin.business.syscenter.menu.bean.Menu;
import cn.warpin.business.syscenter.menu.dao.MenuDao;
import cn.warpin.core.base.condition.EditReq;
import cn.warpin.core.base.condition.QueryCondition;
import cn.warpin.core.base.dao.BaseDao;
import cn.warpin.core.base.service.CommonService;
import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class BizModuleService {
    @Resource
    private BizModuleDao bizModuleDao;
    @Resource
    private MenuDao menuDao;
    @Resource
    private BaseDao baseDao;
    @Resource
    private CommonService commonService;

    public Result save(EditReq in) {
        List entities = in.getEntities();
        for (Map bizModuleVO : entities) {
            BizModule bizModule = new BizModule();
            ObjectUtil.copyMapPropertiesToClass((Map)bizModuleVO, (Object)((Object)bizModule));
            List<Menu> menus = this.menuDao.findByBizModuleCode(bizModule.getParentCode());
            if (ArrayUtil.isNotEmpty(menus)) {
                throw new ResultException(ResCode.ALREADY_EXIST, "\u8be5\u6a21\u5757\u4e0b\u6709\u83dc\u5355\uff0c\u4e0d\u53ef\u4ee5\u518d\u6dfb\u52a0\u5b50\u6a21\u5757");
            }
            if (bizModule.getId() == null) {
                bizModule.setCode(StrUtil.randomKey((int)10));
            }
            this.bizModuleDao.save((Object)bizModule);
        }
        return Result.success();
    }

    public Result update(EditReq in) {
        List entities = in.getEntities();
        for (Map bizModuleVO : entities) {
            BizModule bizModule = new BizModule();
            ObjectUtil.copyMapPropertiesToClass((Map)bizModuleVO, (Object)((Object)bizModule));
            this.bizModuleDao.save((Object)bizModule);
            this.baseDao.update("BizModule", (Object)bizModule, "id");
        }
        return Result.success();
    }

    public Result delete(EditReq in) {
        List entities = in.getEntities();
        for (Map bizModuleVO : entities) {
            Integer id = (Integer)bizModuleVO.get("id");
            this.recursionDelete(id);
        }
        return Result.success();
    }

    public Result query(QueryCondition condition) {
        BizModuleCondition bizModuleCondition = new BizModuleCondition();
        Map entity = (Map)condition.getEntity();
        ObjectUtil.copyMapPropertiesToClass((Map)entity, (Object)((Object)bizModuleCondition));
        condition.setEntity((Object)bizModuleCondition);
        Map voClassMap = ObjectUtil.getVOClassMap((Object)((Object)bizModuleCondition));
        return this.commonService.queryVO(condition, BizModuleVO.class, voClassMap);
    }

    private void recursionDelete(Integer id) {
        List<BizModule> children = this.bizModuleDao.findByParentId(id);
        if (ArrayUtil.isNotEmpty(children)) {
            for (BizModule bizModule : children) {
                this.recursionDelete(bizModule.getId());
            }
        }
        this.bizModuleDao.deleteById(id);
    }
}

