/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.osscenter.service;

import cn.warpin.business.osscenter.params.DeleteReq;
import cn.warpin.core.constant.Constants;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.FileUtil;
import cn.warpin.core.util.SystemUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LocalOSSService {
    public Result upload(MultipartFile file, String type, String context, String content) {
        String fileName = FileUtil.rename((String)file.getOriginalFilename());
        String fileKey = FileUtil.getOssKey((String)fileName, (String)"local-dev", (String)Constants.PROJECT, (String)type, (String)context, (String)content, (String)"0", (boolean)SystemUtil.isWindows());
        String slash = SystemUtil.getSymbol();
        String filePath = Constants.RESOURCE_PATH + slash + fileKey;
        File f = new File(filePath);
        String dir = f.getParent();
        String path = FileUtil.createFile((String)dir, (String)fileName);
        FileUtil.saveFile((MultipartFile)file, (String)path);
        return Result.success((Object)fileKey);
    }

    public Result batchDel(DeleteReq req) {
        String slash = File.separator;
        String basePath = Constants.RESOURCE_PATH;
        List<String> fileNames = req.getFileNames();
        ArrayList<String> undeleted = new ArrayList<String>();
        for (String fileName : fileNames) {
            String filePath = basePath + slash + fileName;
            File file = new File(filePath);
            if (!file.exists() || !file.isFile()) {
                undeleted.add(fileName);
                continue;
            }
            if (file.delete()) continue;
            undeleted.add(fileName);
        }
        if (undeleted.isEmpty()) {
            return Result.success(undeleted);
        }
        return Result.success(undeleted, (ResCode)ResCode.FILE_NOT_EXIST);
    }
}

