/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.osscenter.service;

import cn.warpin.business.osscenter.params.DeleteReq;
import cn.warpin.core.constant.Constants;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.ArrayUtil;
import cn.warpin.core.util.FileUtil;
import cn.warpin.core.util.SystemUtil;
import cn.warpin.thirdPart.aliyun.cfg.AliCfgBuilder;
import cn.warpin.thirdPart.aliyun.oss.AliOSS;
import cn.warpin.thirdPart.aliyun.oss.AliOssCfg;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AliOSSService {
    public Result uploadFileToAli(MultipartFile file, String type, String context, String content) {
        if (file == null) {
            return Result.fail((ResCode)ResCode.FILE_NOT_EXIST, (String)"\u672a\u63a5\u6536\u5230\u4e0a\u4f20\u7684\u6587\u4ef6");
        }
        String fileName = FileUtil.rename((String)file.getOriginalFilename());
        AliOssCfg cfg = AliCfgBuilder.OSSBuilder();
        String fileKey = FileUtil.getOssKey((String)fileName, (String)cfg.path, (String)Constants.PROJECT, (String)type, (String)context, (String)content, (String)"1", (boolean)SystemUtil.isWindows());
        AliOSS.uploadFile((AliOssCfg)cfg, (MultipartFile)file, (String)fileKey, (boolean)false);
        return Result.success((Object)fileName);
    }

    public Result deleteFileFromAli(DeleteReq req) {
        List<String> fileNames = req.getFileNames();
        if (ArrayUtil.isNotEmpty(fileNames)) {
            AliOssCfg cfg = AliCfgBuilder.OSSBuilder();
            AliOSS.delFile((AliOssCfg)cfg, fileNames);
        }
        return Result.success();
    }
}

