/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.osscenter.controller;

import cn.warpin.business.osscenter.service.TencentCOSSService;
import cn.warpin.core.base.BaseController;
import cn.warpin.core.result.Result;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/osscenter/cos"})
public class TencentCOSController
implements BaseController {
    @Resource
    private TencentCOSSService tencentCOSSService;

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    public Result uploadToCos(MultipartFile file) {
        try {
            return this.tencentCOSSService.uploadFileToCos(file);
        }
        catch (Exception e) {
            return Result.exception((Exception)e);
        }
    }

    @PostMapping(value={"/coverUpload"}, consumes={"multipart/form-data"})
    public Result coverUploadToCos(MultipartFile file, String oldFileKey) {
        try {
            return this.tencentCOSSService.coverUploadFileToCos(file, oldFileKey);
        }
        catch (Exception e) {
            return Result.exception((Exception)e);
        }
    }

    @DeleteMapping(value={"/delete"}, consumes={"application/x-www-form-urlencoded"})
    public Result deleteFromCos(String fileNames) {
        try {
            return this.tencentCOSSService.deleteFileFromCos(fileNames);
        }
        catch (Exception e) {
            return Result.exception((Exception)e);
        }
    }
}

