/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.osscenter.controller;

import cn.warpin.business.osscenter.params.DeleteReq;
import cn.warpin.business.osscenter.service.LocalOSSService;
import cn.warpin.core.base.BaseController;
import cn.warpin.core.constant.Constants;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.FileUtil;
import cn.warpin.core.util.SystemUtil;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/osscenter/local"})
public class LocalOSSController
implements BaseController {
    @Resource
    private LocalOSSService localOSSService;

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    public Result upload(MultipartFile file, String type, String context, String content) {
        return this.localOSSService.upload(file, type, context, content);
    }

    @DeleteMapping(value={"/delete"}, consumes={"application/json"})
    public Result deleteFromAli(@RequestBody DeleteReq req) {
        return this.localOSSService.batchDel(req);
    }

    @GetMapping(value={"/view"})
    public ResponseEntity<byte[]> view(@RequestParam(value="fileName") String fileName) throws IOException {
        String slash = SystemUtil.getSymbol();
        String basePath = Constants.RESOURCE_PATH + slash;
        String filepath = basePath + slash + fileName;
        Path path = Paths.get(filepath, new String[0]);
        byte[] imageBytes = Files.readAllBytes(path);
        String ext = FileUtil.getFileExtension((Path)path);
        MediaType contentType = FileUtil.contentTypeSelector((String)ext);
        return ResponseEntity.ok().contentType(contentType).body((Object)imageBytes);
    }
}

