/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.osscenter.controller;

import cn.warpin.business.osscenter.params.DeleteReq;
import cn.warpin.business.osscenter.service.AliOSSService;
import cn.warpin.core.base.BaseController;
import cn.warpin.core.result.Result;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/osscenter/ali"})
public class AliOSSController
implements BaseController {
    @Resource
    private AliOSSService cdnService;

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    public Result upload(MultipartFile file, String type, String context, String content) {
        try {
            return this.cdnService.uploadFileToAli(file, type, context, content);
        }
        catch (Exception e) {
            return Result.exception((Exception)e);
        }
    }

    @DeleteMapping(value={"/delete"}, consumes={"application/json"})
    public Result deleteFromAli(@RequestBody DeleteReq req) {
        try {
            return this.cdnService.deleteFileFromAli(req);
        }
        catch (Exception e) {
            return Result.exception((Exception)e);
        }
    }
}

