/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.auth.jwt.service;

import cn.warpin.business.auth.jwt.LoginData;
import cn.warpin.core.database.redis.RedisOperate;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import cn.warpin.core.security.config.SecurityConfigProperties;
import cn.warpin.core.security.jwt.JwtUtils;
import cn.warpin.core.util.StrUtil;
import io.jsonwebtoken.Claims;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class AuthService {
    @Resource
    private SecurityConfigProperties properties;

    public String createToken(String loginType, String account, Integer id) {
        String token = JwtUtils.createToken((String)loginType, (String)account, (String)id.toString());
        return token;
    }

    public Result authenticate(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        String uri = request.getHeader("X-Original-Uri");
        System.out.printf("---------\u8bf7\u6c42\u5730\u5740\u662f\uff1a%s ----------\n", uri);
        if (this.urlInWhiteList(uri).booleanValue()) {
            return Result.success();
        }
        Claims claims = JwtUtils.checkJWT((String)token);
        if (claims == null) {
            return Result.fail((ResCode)ResCode.TOKEN_EXPIRE_ERROR);
        }
        String version = (String)claims.get((Object)"version");
        String loginType = (String)claims.get((Object)"loginType");
        Map paramsMap = JwtUtils.getJwtClaimParams((String)loginType, (String)claims.getId());
        String redisKey = (String)paramsMap.get("redisKey");
        System.out.printf("id = %s, loginType = %s, version = %s, redisKey = %s \n", claims.getId(), loginType, version, redisKey);
        LoginData loginData = new LoginData();
        loginData.setClaimsId(claims.getId());
        loginData.setLoginType(loginType);
        loginData.setToken(token);
        loginData.setVersion(version);
        Result result = this.validateToken(loginData);
        return result;
    }

    private Result validateToken(LoginData loginData) {
        Map params = JwtUtils.getJwtClaimParams((String)loginData.getLoginType(), (String)loginData.getClaimsId());
        String redisKey = (String)params.get("redisKey");
        String inToken = loginData.getToken();
        String inVersion = loginData.getVersion();
        Map redisDataMap = RedisOperate.getMapValue((String)redisKey);
        String token = (String)redisDataMap.get("token");
        String version = (String)redisDataMap.get("version");
        if (StrUtil.isEmpty((String)token)) {
            return Result.fail((ResCode)ResCode.TOKEN_EXPIRE_ERROR);
        }
        if (!inToken.equals(token)) {
            return Result.fail((ResCode)ResCode.TOKEN_EXPIRE_ERROR);
        }
        if (!inVersion.equals(version)) {
            return Result.fail((ResCode)ResCode.ALREADY_LOGIN);
        }
        return Result.success();
    }

    private Boolean urlInWhiteList(String uri) {
        List whiteList = this.properties.getWhiteList();
        for (String url : whiteList) {
            if (!uri.contains(url)) continue;
            return true;
        }
        return false;
    }
}

