/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.auth.cas.service;

import cn.warpin.business.auth.cas.bean.CasRegisteredInfo;
import cn.warpin.business.auth.cas.bean.Credential;
import cn.warpin.business.auth.cas.bean.RegisteredServices;
import cn.warpin.business.auth.cas.bean.TicketParam;
import cn.warpin.business.syscenter.employee.bean.Admin;
import cn.warpin.business.syscenter.employee.bean.Employee;
import cn.warpin.business.syscenter.employee.dao.AdminDao;
import cn.warpin.business.syscenter.employee.dao.EmployeeDao;
import cn.warpin.core.constant.ApiList;
import cn.warpin.core.constant.Constants;
import cn.warpin.core.constant.EnumStore;
import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import cn.warpin.core.result.Result;
import cn.warpin.core.util.HttpUtil;
import cn.warpin.core.util.ObjectUtil;
import cn.warpin.core.util.StrUtil;
import cn.warpin.core.util.XmlUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CasService {
    @Resource(name="restTemplate")
    private RestTemplate restTemplate;
    @Resource
    private JdbcTemplate casJdbcTemplate;
    @Resource
    private EmployeeDao employeeDao;
    @Resource
    private AdminDao adminDao;
    @Resource
    private HttpUtil httpUtil;

    public Result servicesRegistry(TicketParam ticketParam) {
        String username = null;
        String password = null;
        CasRegisteredInfo casRegisteredInfo = null;
        casRegisteredInfo = ticketParam.getCasRegisteredInfo() == null ? new CasRegisteredInfo() : ticketParam.getCasRegisteredInfo();
        if (StrUtil.isNotEmpty((String)ticketParam.getLoginType()) && ticketParam.getLoginType().equals(EnumStore.LOGIN_TYPE_ADMIN.getKey())) {
            Optional optional = this.adminDao.findById(1);
            if (optional.isPresent()) {
                Admin admin = (Admin)optional.get();
                username = EnumStore.ADMIN_ACCOUNT_1.getKey();
                password = admin.getPassword();
            }
        } else {
            Optional optional = this.employeeDao.findById(ticketParam.getUserId());
            if (optional.isPresent()) {
                Employee employee = (Employee)((Object)optional.get());
                username = employee.getAccount();
                password = employee.getPassword();
            } else {
                return Result.fail((ResCode)ResCode.SYS_EMP_NOT_EXIST, (String)"\u672a\u67e5\u8be2\u5230\u8be5\u7528\u6237");
            }
        }
        casRegisteredInfo.setUsername(username);
        casRegisteredInfo.setPassword(password);
        casRegisteredInfo.setServiceId(ticketParam.getService());
        casRegisteredInfo.setName(ticketParam.getMenuLabel());
        return this.servicesRegistry(casRegisteredInfo);
    }

    private Result servicesRegistry(final CasRegisteredInfo casRegisteredInfo) {
        String username = casRegisteredInfo.getUsername();
        String password = casRegisteredInfo.getPassword();
        casRegisteredInfo.setMatchingStrategy((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("@class", "org.apereo.cas.services.FullRegexRegisteredServiceMatchingStrategy");
            }
        });
        casRegisteredInfo.setAccessStrategy((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("@class", "org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy");
                this.put("enabled", casRegisteredInfo.getAccessStrategyEnable());
                this.put("ssoEnabled", casRegisteredInfo.getAccessStrategySsoEnable());
            }
        });
        String url = Constants.DOMAIN + ApiList.CAS_REGISTER_SERVICE.getValue();
        String resp = this.httpUtil.postJson(this.restTemplate, url, (Object)casRegisteredInfo, username, password);
        if (StrUtil.isNotEmpty((String)resp)) {
            throw new RuntimeException();
        }
        return Result.success();
    }

    public Result getTGT(Credential credential) {
        String url = Constants.DOMAIN + ApiList.CAS_GET_TGT_ST.getValue();
        String tgt = this.httpUtil.postForm(this.restTemplate, url, (Object)credential);
        return Result.success((Object)tgt);
    }

    public Result getST(final TicketParam ticketParam) {
        String username = null;
        String password = null;
        if (StrUtil.isNotEmpty((String)ticketParam.getLoginType()) && ticketParam.getLoginType().equals(EnumStore.LOGIN_TYPE_ADMIN.getKey())) {
            optional = this.adminDao.findById(1);
            if (optional.isPresent()) {
                Admin admin = (Admin)optional.get();
                username = EnumStore.ADMIN_ACCOUNT_1.getKey();
                password = admin.getPassword();
            }
        } else {
            optional = this.employeeDao.findById(ticketParam.getUserId());
            if (optional.isPresent()) {
                Employee employee = (Employee)((Object)optional.get());
                username = employee.getAccount();
                password = employee.getPassword();
            } else {
                return Result.fail((ResCode)ResCode.SYS_EMP_NOT_EXIST, (String)"\u672a\u67e5\u8be2\u5230\u8be5\u7528\u6237");
            }
        }
        String st = "";
        try {
            String url = Constants.DOMAIN + ApiList.CAS_GET_TGT_ST.getValue() + "/" + ticketParam.getTgt();
            st = this.httpUtil.postForm(this.restTemplate, url, (Object)new HashMap<Object, Object>(){
                {
                    this.put("service", ticketParam.getService());
                }
            }, username, password);
        }
        catch (Exception e) {
            throw new ResultException(ResCode.INVALID_TGT, e.getMessage());
        }
        return Result.success((Object)st);
    }

    public Result serviceValidate(TicketParam ticketParam) {
        String url = Constants.DOMAIN + ApiList.CAS_VALIDATE_ST.getValue() + "?service=" + ticketParam.getService() + "&ticket=" + ticketParam.getSt();
        String res = "";
        try {
            res = this.httpUtil.get(this.restTemplate, url, null);
        }
        catch (Exception e) {
            throw new ResultException(ResCode.INVALID_SERVICE_ID);
        }
        return XmlUtil.parseCasResponse((String)res);
    }

    public Result queryOriginById(int id) {
        String sql = "SELECT * FROM registered_services WHERE id = ?";
        RegisteredServices registeredServices = null;
        try {
            registeredServices = (RegisteredServices)this.casJdbcTemplate.queryForObject(sql, (RowMapper)new BeanPropertyRowMapper(RegisteredServices.class), new Object[]{id});
        }
        catch (Exception e) {
            throw new ResultException(ResCode.DB_ERROR);
        }
        return Result.success((Object)registeredServices);
    }

    public Result deleteOriginData(Integer id) {
        if (id == null) {
            return Result.success();
        }
        String sql = "DELETE FROM registered_services WHERE id = ?";
        try {
            this.casJdbcTemplate.update(sql, new Object[]{id});
        }
        catch (Exception e) {
            throw new ResultException(ResCode.DB_ERROR);
        }
        return Result.success();
    }

    public JSONObject exampleRequestValidate(final String service, final String st) {
        JSONObject res = new JSONObject();
        if (st == null || "".equals(st)) {
            res.put((Object)"code", (Object)1001);
            res.put((Object)"msg", (Object)"\u6ca1\u6709\u670d\u52a1\u7968\u636e");
            return res;
        }
        String domain = "http://uqmlmdlk.shenzhuo.vip:13449/javaapi";
        String url = domain + "/cas/serviceValidate";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap map = ObjectUtil.transBean2MultiValueMap((Object)new HashMap<Object, Object>(){
            {
                this.put("service", service);
                this.put("st", st);
            }
        });
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        String response = (String)this.restTemplate.postForObject(url, (Object)entity, String.class, new Object[0]);
        return JSON.parseObject((String)response);
    }
}

