/*
 * Decompiled with CFR 0.152.
 */
package cn.warpin.business.auth.cas.controller;

import cn.warpin.business.auth.cas.bean.Credential;
import cn.warpin.business.auth.cas.bean.RegisteredServices;
import cn.warpin.business.auth.cas.bean.TicketParam;
import cn.warpin.business.auth.cas.service.CasService;
import cn.warpin.core.result.Result;
import jakarta.annotation.Resource;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/cas"})
public class CasController {
    @Resource
    private CasService casService;

    @PostMapping(value={"/servicesRegistry"})
    public Result servicesRegistry(@RequestBody TicketParam ticketParam) {
        return this.casService.servicesRegistry(ticketParam);
    }

    @PostMapping(value={"/getTGT"})
    public Result getTGT(@RequestBody Credential credential) {
        return this.casService.getTGT(credential);
    }

    @PostMapping(value={"/getST"})
    public Result getST(@RequestBody TicketParam ticketParam) {
        return this.casService.getST(ticketParam);
    }

    @PostMapping(value={"/serviceValidate"})
    public Result serviceValidate(@RequestBody TicketParam ticketParam) {
        return this.casService.serviceValidate(ticketParam);
    }

    @PostMapping(value={"/queryById"})
    public Result queryById(@RequestBody RegisteredServices registeredServices) {
        return this.casService.queryOriginById(registeredServices.getId());
    }

    @DeleteMapping(value={"/deleteById"})
    public Result deleteById(@RequestBody RegisteredServices registeredServices) {
        return this.casService.deleteOriginData(registeredServices.getId());
    }

    @PostMapping(value={"/test01"})
    public Result test01(@RequestBody TicketParam ticketParam) {
        System.out.println("-----------> " + String.valueOf(ticketParam));
        return Result.success((Object)ticketParam);
    }

    @RequestMapping(value={"/test02"})
    public Result test02(int id) {
        System.out.println(id);
        return this.casService.queryOriginById(id);
    }
}

