package cn.wangshuaitong.library.module.resultconversion.converter;

import cn.wangshuaitong.library.basic.vo.Result;
import cn.wangshuaitong.library.basic.vo.WebResult;
import lombok.extern.slf4j.Slf4j;

/***
 *@author wangt
 *@date 2018/8/16 15:52
 *@describe web请求结果转换器抽象  处理了所有web请求结果转换器都会遇到的情况
 **/
@Slf4j
public abstract class WebAbstractResultConverter<F extends WebResult,T extends WebResult> extends AbstractResultConverter{
    @Override
    protected Result doConversion(Result fromType) {
        log.debug("处理请求结果抽象，conversion(fromType --> {})",fromType);
        return doWebConversion((F) fromType);
    }

    protected abstract T doWebConversion(F fromType);
}
