package cn.wangshuaitong.library.module.resultconversion.converter;

import cn.wangshuaitong.library.basic.tools.StringTools;
import cn.wangshuaitong.library.basic.vo.response.JsonResult;
import cn.wangshuaitong.library.basic.vo.response.code.ResultCode;
import cn.wangshuaitong.library.basic.vo.service.Result4Handle;
import lombok.extern.slf4j.Slf4j;

/***
 *@author wangt
 *@date 2018/8/16 15:56
 *@describe  Result4Handle类型转JsonResult
 **/
@Slf4j
public class Result4Handle2JsonResultConverter extends WebResultToJsonAbstractResultConverter<Result4Handle,JsonResult> {

    @Override
    protected JsonResult doToJsonResultConversion(Result4Handle fromType) {
        log.debug("ResultHandler to ResponseResult，doConversion(fromType --> {})",fromType);
        JsonResult result = new JsonResult();
        if(fromType.getSuccess()){
            if(StringTools.isEmpty(fromType.getMessage())){
                return result.quickFilling(ResultCode.SUCCESS,fromType.getData());
            }else{
                return result.quickFilling(ResultCode.SUCCESS, fromType.getMessage(),fromType.getData());
            }
        }else{
            if(StringTools.isEmpty(fromType.getMessage())){
                return result.quickFilling(ResultCode.FAIL_COMMON_OPERATION,fromType.getData());
            }else{
                return result.quickFilling(ResultCode.FAIL_COMMON_OPERATION, fromType.getMessage(),fromType.getData());
            }
        }
    }
}
